/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseLsppNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.TokenProviderImpl;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.VcNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.FederationStsProxy;
import com.vmware.srm.client.topology.impl.sso.LsppRotationManagerProvider;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.vmomi.CertificateTokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.sso.client.exception.SsoException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RemoteLsppNode
extends BaseLsppNode
implements LsppRotationManagerProvider {
    private final ProviderImpl _providerImpl = new ProviderImpl();

    RemoteLsppNode(Set<LsppService> lsppSsos) {
        super(lsppSsos);
    }

    @Override
    protected Set<Node<NodeContext>> getNeighbours(List<LsppHelper.DrSite> sites, ServersViewImpl view, TokenProvider tokenProvider) {
        HashSet<Node<NodeContext>> result = new HashSet<Node<NodeContext>>();
        for (LsppHelper.DrSite site : sites) {
            VcNode vcNode = new VcNode(site, view.createPublisher(), this.getTokenProvider(), false);
            result.add(vcNode);
        }
        return result;
    }

    @Override
    TokenProvider getTokenProvider() {
        return this._providerImpl;
    }

    @Override
    public void dispose() {
        this._providerImpl.dispose();
    }

    private class ProviderImpl
    extends TokenProviderImpl
    implements CertificateTokenProvider {
        ProviderImpl() {
            this.setSts(FederationStsProxy.create(RemoteLsppNode.this));
        }

        @Override
        public void login(X509Certificate certificate, PrivateKey privateKey) {
            DrSecurityTokenService sts = FederationStsProxy.create(RemoteLsppNode.this, certificate, privateKey);
            try {
                SsoFacade.getTokenManager().acquireTokenByCertificate(sts);
            }
            catch (SsoException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            this.setSts(sts);
        }
    }
}

