/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.view.certificate.CertificateValidityInfo;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.SrmPairNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.VmomiExtensionServerNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.SrmHelper;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.view.availability.srm.SrmServerImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.srm.SrmServiceImpl;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmNode
extends VmomiExtensionServerNode<SrmServiceImpl, SrmServerImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SrmNode.class);
    private static final String SUPPORTED_VERSIONS_KEY = "vmodlVersion";
    private static final String DEFAULT_VERSIONS_PATH = "/vcdr/vmomi/drversion.xml";

    SrmNode(LsppService serverRegistration, TokenProvider tokenProvider, boolean local, ServersViewImpl.Publisher publisher, VcServer vcServer) {
        super(serverRegistration, "com.vmware.dr.vcDr", tokenProvider, local, publisher, vcServer);
    }

    @Override
    protected Promise<Set<? extends Node<NodeContext>>> discoverNeighbours(ServersViewImpl.Publisher publisher, SrmServiceImpl service, SrmServerImpl server) {
        return SrmHelper.getPairInfoFor(service).thenApply(pairInfo -> {
            LOGGER.trace("SRM '{}' returned pair info '{}'", (Object)server, pairInfo);
            if (pairInfo.repairNeeded) {
                server.setRepairNeeded(pairInfo.remoteSiteRef, pairInfo.srmUuid);
                return Collections.emptySet();
            }
            if (pairInfo.lsppUrl == null) {
                server.complete();
                return Collections.emptySet();
            }
            SrmPairNode spn = new SrmPairNode(server, (SrmHelper.PairInfo)pairInfo);
            return Collections.singleton(spn);
        }).onError(server::complete);
    }

    @Override
    SrmServiceImpl createService(URI url, KeyStore ks, TokenProvider tp) {
        String versionsPath = this.getServerReg().getAttributes().get(SUPPORTED_VERSIONS_KEY);
        if (StringUtils.isEmpty((String)versionsPath)) {
            LOGGER.error("No {} attribute in {}.", (Object)SUPPORTED_VERSIONS_KEY, (Object)this.getServerReg());
            versionsPath = DEFAULT_VERSIONS_PATH;
        }
        return new SrmServiceImpl(url, ks, tp, versionsPath);
    }

    @Override
    protected SrmServerImpl createServer(ServersViewImpl view, VcServer vc, SrmServiceImpl service, LsppService serviceReg, LsppServiceEndpoint vmomiEp, List<CertificateValidityInfo> certificateIssues) {
        return new SrmServerImpl(view, vmomiEp.url, (SrmService)this.getService(), this.getServerReg().getId(), this.isLocal(), certificateIssues, vc);
    }
}

