/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.lspp.monitor.model;

import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.srm.client.utilities.ExecuteOnceOpWrapper;
import com.vmware.srm.client.utilities.HashUtils;
import com.vmware.srm.client.utilities.OperationWaiter;
import com.vmware.srm.client.utilities.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.ArrayUtils;

public class LsppServiceEndpoint {
    public final String type;
    public final String protocol;
    public final URI url;
    public final String[] sslTrust;
    private final ExecuteOnceOpWrapper<Set<X509Certificate>> _genCerts = new ExecuteOnceOpWrapper((Callable)new GenCerts());
    private transient Integer _hashCode;

    LsppServiceEndpoint(String type, String protocol, URI url, String[] sslTrust) {
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol");
        }
        if (url == null) {
            throw new IllegalArgumentException("url");
        }
        this.type = type;
        this.protocol = protocol;
        this.url = url;
        this.sslTrust = ArrayUtils.isEmpty((Object[])sslTrust) ? new String[0] : Arrays.copyOf(sslTrust, sslTrust.length);
    }

    public int hashCode() {
        if (this._hashCode == null) {
            this._hashCode = HashUtils.getHashCode((Object[])new Object[]{this.protocol, this.type, this.url, this.sslTrust});
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LsppServiceEndpoint)) {
            return false;
        }
        LsppServiceEndpoint other = (LsppServiceEndpoint)obj;
        return HashUtils.areEqual((Object)this.type, (Object)other.type) && HashUtils.areEqual((Object)this.protocol, (Object)other.protocol) && HashUtils.areEqual((Object)this.url, (Object)other.url) && HashUtils.areEqual((Object)this.sslTrust, (Object)other.sslTrust);
    }

    public String toString() {
        HashMap<String, Object> members = new HashMap<String, Object>();
        members.put("type", this.type);
        members.put("protocol", this.protocol);
        members.put("url", this.url);
        return StringUtils.getToStringValue((String)"LsppService.LsppServiceEndpoint", members);
    }

    public Set<X509Certificate> getCertificates() {
        OperationWaiter waiter = this._genCerts.invoke();
        if (waiter.getError() != null) {
            throw Exceptions.getRuntimeException(waiter.getError());
        }
        return (Set)waiter.get();
    }

    private class GenCerts
    implements Callable<Set<X509Certificate>> {
        private GenCerts() {
        }

        @Override
        public Set<X509Certificate> call() throws Exception {
            if (ArrayUtils.isEmpty((Object[])LsppServiceEndpoint.this.sslTrust)) {
                return Collections.emptySet();
            }
            HashSet<X509Certificate> certificates = new HashSet<X509Certificate>();
            for (String ssl : LsppServiceEndpoint.this.sslTrust) {
                try {
                    certificates.add((X509Certificate)CertificateUtils.getCertificate(ssl));
                }
                catch (CertificateException e) {
                    String msg = L10N.localize("lsppEndpoint.certGenFailed", LsppServiceEndpoint.this);
                    throw new Topology.TopologyException(msg, e);
                }
                catch (UnsupportedEncodingException e) {
                    String msg = L10N.localize("lsppEndpoint.certGenFailed", LsppServiceEndpoint.this);
                    throw new Topology.TopologyException(msg, e);
                }
            }
            return certificates;
        }
    }
}

