/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.sso.StartupKeyStore;
import com.vmware.srm.client.utilities.ExecuteOnceOpWrapper;
import com.vmware.srm.client.utilities.OperationWaiter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class SolutionUserConfig {
    private static final SolutionUserConfig SOLUTION_USER_CONFIG = new SolutionUserConfig();
    private final ExecuteOnceOpWrapper<Void> _loadOp = new ExecuteOnceOpWrapper(() -> {
        this.load();
        return null;
    });
    private volatile X509Certificate _cert;
    private volatile PrivateKey _key;

    public static SolutionUserConfig get() {
        return SOLUTION_USER_CONFIG;
    }

    private SolutionUserConfig() {
    }

    public X509Certificate getCert() {
        this.init();
        return this._cert;
    }

    public PrivateKey getKey() {
        this.init();
        return this._key;
    }

    public OperationWaiter<Void> ensureLoaded() {
        return this._loadOp.invoke();
    }

    private void load() throws GeneralSecurityException, IOException {
        String alias;
        Config config = Config.get();
        KeyStore keyStore = StartupKeyStore.get().getStore();
        X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias = config.getCertAlias());
        if (cert == null) {
            throw new RuntimeException("No certificate found for alias: '" + alias + "'");
        }
        String pass = config.getKeyStorePass();
        PrivateKey key = (PrivateKey)keyStore.getKey(alias, pass.toCharArray());
        if (key == null) {
            throw new RuntimeException("No private key found for alias: '" + alias + "'");
        }
        this._cert = cert;
        this._key = key;
    }

    private void init() {
        this._loadOp.invoke().get();
    }
}

