/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vc;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.vc.VcService;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.HttpConfigurationManager;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VersionsXmlServiceImpl;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.version.internal.version11;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.KeyStore;

public class VcServiceImpl
extends VersionsXmlServiceImpl<ServiceInstance, ServiceInstanceContent>
implements VcService {
    private static final String VERSIONS_PATH = "/sdk/vimServiceVersions.xml";
    private static final Class<? extends Annotation> MIN_SUPPORTED_VERSION = version11.class;
    public static final Class<? extends Annotation> VERSION = versions.VIM_VERSION_DOTTED;
    public static final ManagedObjectReference SERVICE_INSTANCE;
    public static final VmodlContextInitializer VMODL_INIT;
    private static VcHttpConfigurationManager MANAGER;

    public VcServiceImpl(URI server, KeyStore store, TokenProvider tokenProvider) {
        super(server, VcServiceImpl.MANAGER.getConfiguration(), VMODL_INIT, MIN_SUPPORTED_VERSION, tokenProvider, SERVICE_INSTANCE, "vCenter Server", VERSIONS_PATH);
        MANAGER.addThumbprints(store);
    }

    @Override
    protected String getServerGuid(ServiceInstanceContent content) {
        return content.getAbout().getInstanceUuid();
    }

    @Override
    protected Promise<ServiceInstanceContent> retrieveContent(ServiceInstance serviceInstance) {
        FuturePromise result = new FuturePromise();
        serviceInstance.retrieveContent((Future)result);
        return result;
    }

    @Override
    protected Promise<Void> login(ServiceInstanceContent content, String locale) {
        return this.createLoginStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.loginByToken(locale, (Future)result);
            return result;
        }).thenApply(unused -> null);
    }

    @Override
    protected Promise<Void> logout(ServiceInstanceContent content) {
        return this.createFreeStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.logout((Future)result);
            return result;
        });
    }

    static {
        MANAGER = new VcHttpConfigurationManager();
        VmodlContext context = VmodlContext.createContext((String[])new String[0], (boolean)false);
        VMODL_INIT = new VmodlContextInitializer(context, VERSION);
        SERVICE_INSTANCE = ClientUtils.createMoRef("ServiceInstance", "ServiceInstance", null);
    }

    private static final class VcHttpConfigurationManager
    extends HttpConfigurationManager {
        private VcHttpConfigurationManager() {
        }

        private HttpConfiguration getConfiguration() {
            return this._httpConfiguration;
        }
    }
}

