/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.version;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.PromiseImpl;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.utilities.Exceptions;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.concurrent.CancellationException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public class HttpUtils {
    private static Promise<HttpResponse> doRequest(HttpUriRequest request, CloseableHttpAsyncClient http) {
        try {
            http.start();
            HttpResponsePromise result = new HttpResponsePromise();
            http.execute(request, (FutureCallback)result);
            result.materialize().onSuccess(ununsed -> {
                try {
                    http.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return result;
        }
        catch (RuntimeException e) {
            try {
                http.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public static Promise<HttpResponse> doGet(URI url, KeyStore sslStore) {
        return HttpUtils.doGet(url, sslStore, null);
    }

    public static Promise<HttpResponse> doGet(URI url, ThumbprintVerifier verifier) {
        return HttpUtils.doGet(url, null, verifier);
    }

    public static Promise<HttpResponse> doGet(URI url, KeyStore sslStore, ThumbprintVerifier verifier) {
        HttpGet request = new HttpGet(url);
        CloseableHttpAsyncClient http = HttpUtils.createClient(sslStore, verifier);
        return HttpUtils.doRequest((HttpUriRequest)request, http);
    }

    private static CloseableHttpAsyncClient createClientInt(KeyStore keyStore, ThumbprintVerifier verifier) throws IOException, GeneralSecurityException {
        return HttpUtils.createClientInt((NHttpClientConnectionManager)HttpUtils.createConnectionManager(keyStore, verifier));
    }

    private static CloseableHttpAsyncClient createClientInt(NHttpClientConnectionManager connectionManager) {
        return HttpAsyncClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(HttpUtils.createRequestConfig()).build();
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager(KeyStore keyStore, ThumbprintVerifier verifier) throws IOException, GeneralSecurityException {
        ThumbprintTrustManager trustManager = new ThumbprintTrustManager(keyStore, verifier);
        return HttpUtils.createConnectionManager(trustManager);
    }

    private static ConnectingIOReactor createIOReactor() throws IOReactorException {
        Config config = Config.get();
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout((int)config.getSocketTimeout()).setConnectTimeout((int)config.getConnectTimeout()).build();
        return new DefaultConnectingIOReactor(ioReactorConfig);
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager(ThumbprintTrustManager trustManager) throws IOException, GeneralSecurityException {
        TrustManager[] trustAllCerts = new TrustManager[]{trustManager};
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(null, trustAllCerts, null);
        ConnectingIOReactor ioReactor = HttpUtils.createIOReactor();
        Registry<SchemeIOSessionStrategy> schemeRegistry = HttpUtils.createSchemeRegistry(ctx, trustManager);
        return new PoolingNHttpClientConnectionManager(ioReactor, schemeRegistry);
    }

    private static Registry<SchemeIOSessionStrategy> createSchemeRegistry(SSLContext sslContext, ThumbprintTrustManager trustManager) {
        RegistryBuilder builder = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE);
        builder.register("https", (Object)new SSLIOSessionStrategy(sslContext, (X509HostnameVerifier)new ThumbprintTrustManager.HostnameVerifier(trustManager)));
        return builder.build();
    }

    private static RequestConfig createRequestConfig() {
        Config config = Config.get();
        return RequestConfig.custom().setExpectContinueEnabled(false).setSocketTimeout((int)config.getSocketTimeout()).setConnectTimeout((int)config.getConnectTimeout()).setCookieSpec("standard").build();
    }

    private static CloseableHttpAsyncClient createClient(KeyStore sslStore, ThumbprintVerifier verifier) {
        try {
            return HttpUtils.createClientInt(sslStore, verifier);
        }
        catch (Exception e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
    }

    static final class HttpResponsePromise
    extends PromiseImpl<HttpResponse>
    implements FutureCallback<HttpResponse> {
        HttpResponsePromise() {
        }

        public void cancelled() {
            this.setError(new CancellationException());
        }

        public void completed(HttpResponse result) {
            this.setResult(result);
        }

        public void failed(Exception exc) {
            this.setError(exc);
        }
    }
}

