/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.srm.client.reactive.PromiseResult;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.ManagedObjectProxy;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingMethodInterceptor
implements MethodInterceptor {
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"dr.audit.vmomi.serviceimpl");
    private final ManagedObject _target;
    private final String _logPrefix;

    LoggingMethodInterceptor(ManagedObject target, URI server, String serverDescription) {
        this._target = target;
        this._logPrefix = serverDescription + " at " + server + ":";
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Validate.notEmpty((Object[])args, (String)"args");
        Validate.notEmpty((Object[])args);
        Validate.isTrue((boolean)(args[args.length - 1] instanceof Future));
        ManagedObjectProxy moProxy = (ManagedObjectProxy)obj;
        RequestContext rc = moProxy._getRequestContext();
        if (rc != null) {
            ((Stub)this._target)._setRequestContext(rc);
        }
        ManagedObjectReference ref = this._target._getRef();
        try {
            return proxy.invoke((Object)this._target, this.fixArgs(method, ref, args));
        }
        catch (Throwable t) {
            AUDIT_LOGGER.error("{} '{}' on '{}:{}:{}' failed with '{}'{}", new Object[]{this._logPrefix, method.getName(), ref.getType(), ref.getValue(), ref.getServerGuid(), t, "."});
            throw t;
        }
    }

    private Object[] fixArgs(Method method, ManagedObjectReference ref, Object[] args) {
        Future futureArg = (Future)args[args.length - 1];
        Object[] fixedArgs = Arrays.copyOf(args, args.length);
        FuturePromise resultPromise = new FuturePromise();
        fixedArgs[fixedArgs.length - 1] = resultPromise;
        resultPromise.materialize().onSuccess(promiseResult -> {
            PromiseResult pr = (PromiseResult)promiseResult;
            if (pr.isSuccessful()) {
                futureArg.set(pr.getResult());
                AUDIT_LOGGER.info("{} '{}' on '{}:{}:{}' completed.", new Object[]{this._logPrefix, method.getName(), ref.getType(), ref.getValue(), ref.getServerGuid()});
                return;
            }
            Exception cause = pr.getError();
            futureArg.setException(cause);
            AUDIT_LOGGER.warn("{} '{}' on '{}:{}:{}' failed with '{}'{}", new Object[]{this._logPrefix, method.getName(), ref.getType(), ref.getValue(), ref.getServerGuid(), cause, "."});
        });
        return fixedArgs;
    }
}

