/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.vmomi.ssl.DynamicVerifier;
import com.vmware.srm.client.utilities.Pair;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.security.KeyStore;
import org.apache.commons.lang.Validate;

public class SslTrust {
    private static final KeyStore TRUST_STORE = Config.get().getTrustStore();

    public static KeyStore getTrustStore() {
        return TRUST_STORE;
    }

    public static TrustData get(KeyStore store) {
        Validate.notNull((Object)store, (String)"store");
        if (TRUST_STORE != null) {
            return new TrustData(null, TRUST_STORE);
        }
        DynamicVerifier verifier = new DynamicVerifier();
        verifier.addThumbprints(store);
        return new TrustData(verifier, store);
    }

    public static TrustData get(String thumbprint) {
        Validate.notEmpty((String)thumbprint, (String)"thumbprint");
        if (TRUST_STORE != null) {
            return new TrustData(null, TRUST_STORE);
        }
        DynamicVerifier verifier = new DynamicVerifier();
        verifier.addThumbprint(thumbprint);
        return new TrustData(verifier, null);
    }

    public static final class TrustData
    extends Pair<ThumbprintVerifier, KeyStore> {
        TrustData(ThumbprintVerifier verifier, KeyStore store) {
            super((Object)verifier, (Object)store);
        }
    }
}

