/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.srm.client.topology.impl.common.Utils;
import com.vmware.srm.client.topology.impl.vmomi.ConnectionParams;
import com.vmware.srm.client.topology.impl.vmomi.ssl.Verifiers;
import com.vmware.srm.client.utilities.OpIdAccessor;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.query.version.version1;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.Session;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VlsiClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VlsiClientUtils.class);
    private static final List<Client> CLIENTS = Collections.synchronizedList(new ArrayList());
    private static final Class<? extends Annotation> CLIENTS_VERSION = version1.class;
    private static final URI FAKE_CLIENT_URI = URI.create("https://dr-client-utils");
    private static final String THUMBPRINT_ALG = "SHA-256";

    public static ThumbprintVerifier createVerifier(String thumbprint) {
        return new Verifiers.DefaultVerifier(thumbprint);
    }

    static HttpConfiguration createHttpConfig(URI proxy, ThumbprintVerifier verifier, KeyStore keyStore) {
        HttpConfiguration httpConfig = HttpConfiguration.Factory.newInstance();
        if (proxy != null) {
            httpConfig.setDefaultProxy(proxy.getHost(), proxy.getPort(), proxy.getScheme());
        }
        httpConfig.setNonBlockingIo(true);
        httpConfig.setThumbprintVerifier(verifier);
        httpConfig.setTrustStore(keyStore);
        httpConfig.setMaxConnections(ConnectionParams.getMaxConnections());
        httpConfig.setDefaultMaxConnectionsPerRoute(ConnectionParams.getMaxConnectionsPerRoute());
        httpConfig.setConnectTimeoutMs(ConnectionParams.getConnectTimeout());
        httpConfig.setTimeoutMs(ConnectionParams.getSocketTimeout());
        return httpConfig;
    }

    static HttpClientConfiguration createClientConfig(HttpConfiguration httpConfig) {
        HttpClientConfiguration clientConfig = HttpClientConfiguration.Factory.newInstance();
        clientConfig.setHttpConfiguration(httpConfig);
        clientConfig.setExecutor(Utils.getExecutor());
        return clientConfig;
    }

    public static HttpConfiguration createPermanentHttpConfig(URI proxy, ThumbprintVerifier verifier, KeyStore keyStore) {
        HttpConfiguration httpConfiguration = VlsiClientUtils.createHttpConfig(proxy, verifier, keyStore);
        HttpClientConfiguration clientConfiguration = VlsiClientUtils.createClientConfig(httpConfiguration);
        Client client = Client.Factory.createClient((URI)FAKE_CLIENT_URI, CLIENTS_VERSION, (VmodlContext)VmodlContext.createContext((String[])new String[0]), (ClientConfiguration)clientConfiguration);
        CLIENTS.add(client);
        return httpConfiguration;
    }

    public static String[] computeThumbprints(KeyStore trustStore) throws GeneralSecurityException {
        List<X509Certificate> certificates = VlsiClientUtils.getCertificates(trustStore);
        ArrayList<String> result = new ArrayList<String>(certificates.size());
        for (X509Certificate cert : certificates) {
            result.add(SslUtil.computeCertificateThumbprint((X509Certificate)cert, (String)THUMBPRINT_ALG));
        }
        return result.toArray(new String[result.size()]);
    }

    public static List<X509Certificate> getCertificates(KeyStore trustStore) throws KeyStoreException {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(trustStore.size());
        for (String alias : Collections.list(trustStore.aliases())) {
            X509Certificate cert;
            if (!trustStore.isCertificateEntry(alias)) continue;
            try {
                cert = (X509Certificate)trustStore.getCertificate(alias);
            }
            catch (KeyStoreException exc) {
                LOGGER.warn("Unable to get certificate for alias '{}'", (Object)alias);
                continue;
            }
            result.add(cert);
        }
        return result;
    }

    public static ManagedObjectType getType(ManagedObjectReference ref, VmodlTypeMap typeMap) {
        if (ref == null || ref.getType() == null) {
            throw new IllegalArgumentException("ref");
        }
        VmodlType vmodlType = typeMap.getVmodlType(ref.getType());
        if (!(vmodlType instanceof ManagedObjectType)) {
            throw new RuntimeException("No class registered for " + ref);
        }
        return (ManagedObjectType)vmodlType;
    }

    public static void setOperationId(Stub stub) {
        String opId = OpIdAccessor.get();
        if (StringUtils.isEmpty((String)opId)) {
            LOGGER.warn("No opId defined for '{}'", (Object)stub);
            return;
        }
        RequestContext ctx = stub._getRequestContext();
        if (ctx == null) {
            ctx = new RequestContextImpl();
            stub._setRequestContext(ctx);
        }
        ctx.put((Object)"operationID", (Object)opId);
    }

    static void setAuthenticationData(Stub stub, SamlToken token, PrivateKey key) {
        RequestContextImpl context = new RequestContextImpl();
        RequestContext prevContext = stub._getRequestContext();
        if (prevContext != null) {
            context.putAll((Map)prevContext);
        }
        context.setSignInfo((SignInfo)new SignInfoImpl(key, token));
        stub._setRequestContext((RequestContext)context);
    }

    public static <T extends ManagedObject> T createStub(ManagedObjectReference ref, Client client, VmodlTypeMap typeMap) {
        Class<T> clazz = VlsiClientUtils.getClass(ref, typeMap);
        ManagedObject result = client.createStub(clazz, ref);
        VlsiClientUtils.setOperationId((Stub)result);
        return (T)result;
    }

    public static <T extends ManagedObject> Class<T> getClass(ManagedObjectReference ref, VmodlTypeMap typeMap) {
        ManagedObjectType vmodlType = VlsiClientUtils.getType(ref, typeMap);
        return vmodlType.getTypeClass();
    }

    public static TypeName getTypeName(String wsdlType, VmodlTypeMap typeMap) {
        return new TypeNameImpl(typeMap.getVmodlType(wsdlType));
    }

    public static String getSessionId(Client vmomiClient) {
        ProtocolBinding binding = vmomiClient.getBinding();
        Session session = binding.getSession();
        return session == null ? null : session.getId();
    }

    public static void setSessionId(Client vmomiClient, String id) {
        Validate.notEmpty((String)id, (String)"id");
        ProtocolBinding binding = vmomiClient.getBinding();
        Session session = binding.createSession(id);
        binding.setSession(session);
    }

    public static void clearSessionId(Client vmomiClient) {
        vmomiClient.getBinding().clearSession();
    }
}

