/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.KeyStoreConfig;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.util.Validate;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpConfigurationImpl
implements HttpConfiguration {
    private static final long DEFAULT_KEEP_ALIVE_PERIOD = 45000L;
    private static final String DEFAULT_USER_AGENT = "VMware vim-java 1.0";
    private static final int DEFAULT_RETRY_LIMIT = 3;
    private static final String KEY_ALIAS_PROP = "com.vmware.vim.vmomi.client.http.keyAlias";
    private static final String KEY_PASSWORD_PROP = "com.vmware.vim.vmomi.client.http.keyPassword";
    private static final String KEY_STORE_PROP = "com.vmware.vim.vmomi.client.http.keyStorePassword";
    private static final String KEY_STORE_PATH_PROP = "com.vmware.vim.vmomi.client.http.keyStorePath";
    private static final String KEY_STORE_TYPE_PROP = "com.vmware.vim.vmomi.client.http.keyStoreType";
    private static final String TRUST_STORE_PASSWORD_PROP = "com.vmware.vim.vmomi.client.http.trustStorePassword";
    private static final String TRUST_STORE_PATH_PROP = "com.vmware.vim.vmomi.client.http.trustStorePath";
    private final KeyStoreConfig _keyStoreConfig;
    private ThumbprintVerifier _thumbprintVerifier;
    private KeyStore _keyStore;
    private KeyStore _trustStore;
    private HttpConfiguration.CompressionSupport _compressionSupport;
    private int _timeout;
    private int _connectTimeout;
    private boolean _disableNagle;
    private boolean _checkStaleConnection;
    private int _maxConnections;
    private String _defaultProxyHost;
    private int _defaultProxyPort;
    private String _defaultProxyScheme;
    private int _defaultMaxConnectionsPerRoute;
    private Map<String, HttpConfiguration.RouteConfiguration> _routes = new HashMap<String, HttpConfiguration.RouteConfiguration>();
    private CompiledHttpConfiguration _compiledConfig;
    private long _keepAlivePeriod = 45000L;
    private int _nioThreadPoolSize = Runtime.getRuntime().availableProcessors();
    private boolean _nioMode = false;
    private String[] _enabledProtocols;
    private CertStore _crlCertStore;
    private String _userAgent = "VMware vim-java 1.0";
    private int _retryLimit = 3;
    private HttpConfiguration.HeadersProvider headersProvider;

    public HttpConfigurationImpl() {
        this.setMaxConnections(20);
        this.setDefaultMaxConnectionsPerRoute(20);
        this.setTimeoutMs(1200000);
        this.setConnectTimeoutMs(0);
        this.setDisableNagle(true);
        this.setCheckStaleConnection(true);
        this.setCompressionSupport(HttpConfiguration.CompressionSupport.DISABLE);
        this._keyStoreConfig = new KeyStoreConfigImpl();
    }

    @Override
    public synchronized void setTimeoutMs(int ms) {
        this.assertNotCompiled();
        if (ms < 0) {
            throw new IllegalArgumentException("Non-negative value expected");
        }
        this._timeout = ms;
    }

    @Override
    public int getTimeoutMs() {
        return this._timeout;
    }

    @Override
    public synchronized void setDisableNagle(boolean use) {
        this.assertNotCompiled();
        this._disableNagle = use;
    }

    @Override
    public boolean getDisableNagle() {
        return this._disableNagle;
    }

    @Override
    public synchronized void setCheckStaleConnection(boolean check) {
        this.assertNotCompiled();
        this._checkStaleConnection = check;
    }

    @Override
    public boolean getCheckStaleConnection() {
        return this._checkStaleConnection;
    }

    @Override
    public synchronized void setThumbprintVerifier(ThumbprintVerifier verifier) {
        this.assertNotCompiled();
        this._thumbprintVerifier = verifier;
    }

    @Override
    public ThumbprintVerifier getThumbprintVerifier() {
        return this._thumbprintVerifier;
    }

    @Override
    public synchronized void setTrustStore(KeyStore trustStore) {
        this.assertNotCompiled();
        this._trustStore = trustStore;
    }

    @Override
    public KeyStore getTrustStore() {
        return this._trustStore;
    }

    @Override
    public synchronized void setKeyStore(KeyStore keyStore) {
        this.assertNotCompiled();
        this._keyStore = keyStore;
    }

    @Override
    public KeyStore getKeyStore() {
        return this._keyStore;
    }

    @Override
    public KeyStoreConfig getKeyStoreConfig() {
        return this._keyStoreConfig;
    }

    @Override
    public synchronized void setMaxConnections(int max) {
        this.assertNotCompiled();
        this._maxConnections = max;
    }

    @Override
    public int getMaxConnections() {
        return this._maxConnections;
    }

    @Override
    public Collection<HttpConfiguration.RouteConfiguration> getRouteConfigurations() {
        return this._routes.values();
    }

    private String routeKey(String hostname, int port, String scheme) {
        return hostname + "@" + port + "@" + scheme;
    }

    @Override
    public int getMaxConnectionsPerRoute(String hostname, int port, String scheme) {
        String key = this.routeKey(hostname, port, scheme);
        if (this._routes.containsKey(key)) {
            return this._routes.get(key).getMaxConnections();
        }
        return this._defaultMaxConnectionsPerRoute;
    }

    @Override
    public synchronized void setMaxConnectionsPerRoute(final String hostname, final int port, final String scheme, final int connections) {
        this.assertNotCompiled();
        this._routes.put(this.routeKey(hostname, port, scheme), new HttpConfiguration.RouteConfiguration(){

            @Override
            public int getMaxConnections() {
                return connections;
            }

            @Override
            public String getScheme() {
                return scheme;
            }

            @Override
            public int getPort() {
                return port;
            }

            @Override
            public String getHostName() {
                return hostname;
            }
        });
    }

    @Override
    public synchronized void setDefaultMaxConnectionsPerRoute(int connections) {
        this.assertNotCompiled();
        this._defaultMaxConnectionsPerRoute = connections;
    }

    @Override
    public int getDefaultMaxConnectionsPerRoute() {
        return this._defaultMaxConnectionsPerRoute;
    }

    @Override
    public synchronized void setMaxConnectionsPerRoute(String hostname, int port, int connections) {
        this.assertNotCompiled();
        this.setMaxConnectionsPerRoute(hostname, port, "http", connections);
        this.setMaxConnectionsPerRoute(hostname, port, "https", connections);
    }

    @Override
    public HttpConfiguration.CompressionSupport getCompressionSupport() {
        return this._compressionSupport;
    }

    @Override
    public synchronized void setCompressionSupport(HttpConfiguration.CompressionSupport compressionSupport) {
        this.assertNotCompiled();
        if (compressionSupport == null) {
            throw new IllegalArgumentException("CompressionSupport is required");
        }
        this._compressionSupport = compressionSupport;
    }

    @Override
    public String getDefaultProxyHost() {
        return this._defaultProxyHost;
    }

    @Override
    public int getDefaultProxyPort() {
        return this._defaultProxyPort;
    }

    @Override
    public String getDefaultProxyScheme() {
        return this._defaultProxyScheme;
    }

    @Override
    public synchronized void setDefaultProxy(String host, int port, String scheme) {
        this.assertNotCompiled();
        this._defaultProxyHost = host;
        this._defaultProxyPort = port;
        this._defaultProxyScheme = scheme;
    }

    void resetCompiledConfiguration() {
        this._compiledConfig = null;
    }

    synchronized void setCompiledConfiguration(CompiledHttpConfiguration config) {
        this.assertNotCompiled();
        this._compiledConfig = config;
    }

    CompiledHttpConfiguration getCompiledConfiguration() {
        return this._compiledConfig;
    }

    private void assertNotCompiled() {
        if (this._compiledConfig != null) {
            throw new IllegalStateException("Configuration is already compiled and can not be modified.");
        }
    }

    @Override
    public synchronized void setKeepAlivePeriod(long period) {
        this.assertNotCompiled();
        this._keepAlivePeriod = period;
    }

    @Override
    public long getKeepAlivePeriod() {
        return this._keepAlivePeriod;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void setNioThreadPoolSize(int threads) {
        this.assertNotCompiled();
        if (threads <= 0) {
            throw new IllegalArgumentException("Thread count should be > 0");
        }
        this._nioThreadPoolSize = threads;
    }

    @Override
    public int getNioThreadPoolSize() {
        return this._nioThreadPoolSize;
    }

    @Override
    public void setNonBlockingIo(boolean nioMode) {
        this.assertNotCompiled();
        this._nioMode = nioMode;
    }

    @Override
    public boolean getNonBlockingIo() {
        return this._nioMode;
    }

    @Override
    public void setEnabledProtocols(String[] enabledProtocols) {
        this._enabledProtocols = enabledProtocols;
    }

    @Override
    public String[] getEnabledProtocols() {
        return this._enabledProtocols;
    }

    @Override
    public void setConnectTimeoutMs(int ms) {
        this.assertNotCompiled();
        if (ms < 0) {
            throw new IllegalArgumentException("Non-negative value expected");
        }
        this._connectTimeout = ms;
    }

    @Override
    public int getConnectTimeoutMs() {
        return this._connectTimeout;
    }

    @Override
    @Deprecated
    public synchronized void setCookieSpec(String cookieSpec) {
    }

    @Override
    @Deprecated
    public String getCookieSpec() {
        return "standard";
    }

    @Override
    public void setCrlCertStore(CertStore certStore) {
        this.assertNotCompiled();
        this._crlCertStore = certStore;
    }

    @Override
    public CertStore getCrlCertStore() {
        return this._crlCertStore;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.assertNotCompiled();
        Validate.notNull((String)"The userAgent value is required", (Object)userAgent);
        this._userAgent = userAgent;
    }

    @Override
    public String getUserAgent() {
        return this._userAgent;
    }

    @Override
    public void setRetryLimit(int retryLimit) {
        this._retryLimit = retryLimit;
    }

    @Override
    public int getRetryLimit() {
        return this._retryLimit;
    }

    @Override
    public HttpConfiguration.HeadersProvider getHeadersProvider() {
        return this.headersProvider;
    }

    @Override
    public void setHeadersProvider(HttpConfiguration.HeadersProvider headersProvider) {
        this.headersProvider = headersProvider;
    }

    public String toString() {
        return String.format("nioMode: %b, nioThreadPoolSize: %d\nreadTimeout: %d ms, connectTimeout: %d ms\ncheckStaleConnection: %b, keepAlivePeriod: %d ms\ndisableNagle: %b, maxConnections: %d\nretryCount: %d", this._nioMode, this._nioThreadPoolSize, this._timeout, this._connectTimeout, this._checkStaleConnection, this._keepAlivePeriod, this._disableNagle, this._maxConnections, this._retryLimit);
    }

    public static class BasicHeader
    implements HttpConfiguration.Header {
        private final String name;
        private final String value;

        public BasicHeader(String name, String value) {
            Objects.requireNonNull(name, "name cannot be null");
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name cannot be empty");
            }
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s: %s", this.name, this.value);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasicHeader other = (BasicHeader)obj;
            if (!this.name.equalsIgnoreCase(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    private class KeyStoreConfigImpl
    implements KeyStoreConfig {
        private String _keyAlias = System.getProperty("com.vmware.vim.vmomi.client.http.keyAlias");
        private transient String _keyPassword = System.getProperty("com.vmware.vim.vmomi.client.http.keyPassword");
        private transient String _keyStorePassword = System.getProperty("com.vmware.vim.vmomi.client.http.keyStorePassword");
        private String _keyStorePath = System.getProperty("com.vmware.vim.vmomi.client.http.keyStorePath");
        private String _keyStoreType = System.getProperty("com.vmware.vim.vmomi.client.http.keyStoreType", "JKS");
        private transient String _trustStorePassword = System.getProperty("com.vmware.vim.vmomi.client.http.trustStorePassword");
        private String _trustStorePath = System.getProperty("com.vmware.vim.vmomi.client.http.trustStorePath");

        @Override
        public String getKeyAlias() {
            return this._keyAlias;
        }

        @Override
        public String getKeyStorePassword() {
            return this._keyStorePassword;
        }

        @Override
        public String getKeyStorePath() {
            return this._keyStorePath;
        }

        @Override
        public String getTrustStorePassword() {
            return this._trustStorePassword;
        }

        @Override
        public String getTrustStorePath() {
            return this._trustStorePath;
        }

        @Override
        public String getKeyStoreType() {
            return this._keyStoreType;
        }

        @Override
        public String getKeyPassword() {
            return this._keyPassword;
        }

        @Override
        public synchronized void setKeyAlias(String keyAlias) {
            HttpConfigurationImpl.this.assertNotCompiled();
            this._keyAlias = keyAlias;
        }

        @Override
        public synchronized void setKeyPassword(String keyPassword) {
            HttpConfigurationImpl.this.assertNotCompiled();
            this._keyPassword = keyPassword;
        }

        @Override
        public synchronized void setKeyStorePassword(String keyStorePassword) {
            HttpConfigurationImpl.this.assertNotCompiled();
            this._keyStorePassword = keyStorePassword;
        }

        @Override
        public synchronized void setKeyStorePath(String keyStorePath) {
            HttpConfigurationImpl.this.assertNotCompiled();
            this._keyStorePath = keyStorePath;
        }

        @Override
        public synchronized void setKeyStoreType(String keyStoreType) {
            HttpConfigurationImpl.this.assertNotCompiled();
            this._keyStoreType = keyStoreType;
        }

        @Override
        public synchronized void setTrustStorePath(String trustStorePath) {
            HttpConfigurationImpl.this.assertNotCompiled();
            this._trustStorePath = trustStorePath;
        }

        @Override
        public synchronized void setTrustStorePassword(String trustStorePassword) {
            HttpConfigurationImpl.this.assertNotCompiled();
            this._trustStorePassword = trustStorePassword;
        }
    }
}

