/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client.impl.ssl;

import com.vmware.identity.wstrust.client.SecurityTokenServiceConfig;
import com.vmware.identity.wstrust.client.impl.ValidateUtil;
import com.vmware.identity.wstrust.client.impl.ssl.SslUtil;
import com.vmware.identity.wstrust.client.impl.ssl.UntrustedSslCertificateException;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StsSslTrustManager
implements X509TrustManager {
    private static final Logger log = LoggerFactory.getLogger(StsSslTrustManager.class);
    private static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";
    private static final String DEFAULT_TRUST_MANAGER_ALGO = "PKIX";
    private static final String TRUSTED_CERT_ALIAS = "StsSslTrustCert";
    private final X509TrustManager _certTrustManager;
    private final String _thumbprint;
    private final CertStore _crlCertStore;

    public StsSslTrustManager(SecurityTokenServiceConfig.ConnectionConfig config) {
        assert (config != null);
        Certificate[] trustedCert = config.getTrustedRootCertificates();
        if (trustedCert.length == 0) {
            this._certTrustManager = null;
        } else {
            KeyStore trustStore = StsSslTrustManager.createDefaultTrustStore(trustedCert);
            this._certTrustManager = StsSslTrustManager.createDefaultTrustManager(trustStore);
        }
        this._thumbprint = config.getTrustedCertificateThumbprint();
        this._crlCertStore = config.getCrlCertStore();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this._crlCertStore != null && !StsSslTrustManager.skipServerCertCrlChecking()) {
            try {
                for (X509Certificate cert : chain) {
                    X509CRLSelector selector = new X509CRLSelector();
                    selector.setCertificateChecking(cert);
                    for (CRL cRL : this._crlCertStore.getCRLs(selector)) {
                        if (!cRL.isRevoked(cert)) continue;
                        throw new CertificateException("Server certificate revoked by the CRL");
                    }
                }
            }
            catch (CertStoreException e) {
                throw new CertificateException("Failed to validate certificate against CertStore CRL", e);
            }
        }
        if (this._certTrustManager != null) {
            try {
                this._certTrustManager.checkServerTrusted(chain, authType);
                if (log.isDebugEnabled()) {
                    log.debug("The SSL certificate of STS service was successfully verified against the list of client-trusted certificates");
                }
            }
            catch (CertificateException e) {
                if (log.isDebugEnabled()) {
                    log.debug("The SSL certificate of STS service cannot be verified against the list of client-trusted certificates", (Throwable)e);
                }
                this.validateServerIdentityWithThumbprint(chain);
            }
        } else {
            this.validateServerIdentityWithThumbprint(chain);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this._certTrustManager != null) {
            this._certTrustManager.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this._certTrustManager != null ? this._certTrustManager.getAcceptedIssuers() : new X509Certificate[]{};
    }

    private static KeyStore createDefaultTrustStore(Certificate ... cert) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(DEFAULT_TRUSTSTORE_TYPE);
            keyStore.load(null, null);
            if (cert != null) {
                for (int i = 0; i < cert.length; ++i) {
                    assert (cert[i] != null);
                    keyStore.setCertificateEntry(TRUSTED_CERT_ALIAS + i, cert[i]);
                }
            }
        }
        catch (Exception e) {
            String errMsg = "Error creating the default key store";
            log.error(errMsg, (Throwable)e);
            throw new IllegalStateException(errMsg, e);
        }
        return keyStore;
    }

    private static X509TrustManager createDefaultTrustManager(KeyStore trustStore) {
        TrustManagerFactory factory;
        assert (trustStore != null);
        try {
            factory = TrustManagerFactory.getInstance(DEFAULT_TRUST_MANAGER_ALGO);
            factory.init(trustStore);
        }
        catch (Exception e) {
            String errMsg = "Unable to create trust manager factory";
            log.error(errMsg, (Throwable)e);
            throw new IllegalStateException(errMsg, e);
        }
        for (TrustManager trustManager : factory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("Unable to find default trust manager");
    }

    private void validateServerIdentityWithThumbprint(X509Certificate[] serverId) throws CertificateException {
        assert (!ValidateUtil.isEmpty(serverId));
        X509Certificate serverIdLeafCert = serverId[0];
        assert (serverIdLeafCert != null);
        String serverIdThumbprint = SslUtil.computeCertificateThumbprint(serverIdLeafCert);
        if (this._thumbprint == null || !this._thumbprint.equals(serverIdThumbprint)) {
            if (log.isDebugEnabled()) {
                log.debug("The SSL certificate of STS service cannot be verified against the client-trusted thumbprint");
            }
            throw new UntrustedSslCertificateException("The SSL certificate of STS service cannot be verified", serverId, serverIdThumbprint);
        }
        if (log.isDebugEnabled()) {
            log.debug("The SSL certificate of STS service was successfully verified against the client-trusted thumbprint");
        }
    }

    private static boolean skipServerCertCrlChecking() {
        boolean result = false;
        try {
            File file = new File("WstClientSkipServerCertCrlChecking");
            if (file.exists() && file.isFile()) {
                result = true;
                log.warn(String.format("skipping CRL check for server cert because of existence of file: %s", file.getAbsolutePath()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

