/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.utilities;

import java.util.Arrays;

public class Exceptions {
    public static RuntimeException getRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return Exceptions.fixStackTrace(new RuntimeException(e.getLocalizedMessage(), e));
    }

    private static <E extends RuntimeException> E fixStackTrace(E e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        int length = stackTrace.length;
        if (length > 0) {
            StackTraceElement[] newTrace = Arrays.copyOfRange(stackTrace, 1, length);
            e.setStackTrace(newTrace);
        }
        return e;
    }
}

