/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.utilities;

import com.vmware.srm.client.utilities.ExpBackOffCalculator;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpBackOffCallable<T>
implements Callable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpBackOffCallable.class);
    private final Callable<T> _call;
    private final AtomicReference<State<T>> _current;

    public ExpBackOffCallable(Callable<T> call) {
        this._call = call;
        this._current = new AtomicReference<Running>(new Running());
    }

    @Override
    public T call() throws Exception {
        return (T)this._current.get().call();
    }

    public static boolean shouldDoBackOff(Exception exc) {
        if (exc instanceof SslException) {
            return false;
        }
        return exc instanceof ConnectionException || exc instanceof TransportProtocolException || exc instanceof UnexpectedStatusCodeException;
    }

    private final class Probe
    implements State<T> {
        private static final int PROBE_CALLS = 2;
        private final ExpBackOffCalculator _calc;
        private final AtomicInteger _probeCallsLeft = new AtomicInteger(2);
        private final CountDownLatch _currentStateChanged = new CountDownLatch(1);
        private final AtomicInteger _succeededCalls = new AtomicInteger(0);

        Probe(ExpBackOffCalculator calc) {
            this._calc = calc;
        }

        @Override
        public T call() throws Exception {
            if (this.shouldDoProbe()) {
                return this.doProbe();
            }
            this._currentStateChanged.await();
            return ((State)ExpBackOffCallable.this._current.get()).call();
        }

        private T doProbe() throws Exception {
            try {
                Object result = ExpBackOffCallable.this._call.call();
                if (this._succeededCalls.incrementAndGet() == 2) {
                    ExpBackOffCallable.this._current.set(new Running());
                    this._currentStateChanged.countDown();
                }
                return result;
            }
            catch (Exception exc) {
                if (ExpBackOffCallable.shouldDoBackOff(exc)) {
                    Error newState = new Error(exc, this._calc);
                    if (ExpBackOffCallable.this._current.compareAndSet(this, newState)) {
                        newState.scheduleReset();
                        this._currentStateChanged.countDown();
                    }
                } else if (this._succeededCalls.incrementAndGet() == 2) {
                    ExpBackOffCallable.this._current.set(new Running());
                    this._currentStateChanged.countDown();
                }
                throw exc;
            }
        }

        private boolean shouldDoProbe() {
            boolean succeeded = false;
            int left = 0;
            while (!succeeded && (left = this._probeCallsLeft.get()) > 0) {
                succeeded = this._probeCallsLeft.compareAndSet(left, left - 1);
            }
            return succeeded;
        }
    }

    private final class Error
    implements State<T> {
        private final Exception _err;
        private final ExpBackOffCalculator _calc;
        private volatile Date _expTime = new Date(Long.MAX_VALUE);

        Error(Exception err) {
            this(err, new ExpBackOffCalculator());
        }

        Error(Exception err, ExpBackOffCalculator calc) {
            this._err = err;
            this._calc = calc;
        }

        @Override
        public T call() throws Exception {
            Date now = new Date();
            if (this._expTime.after(now)) {
                throw this._err;
            }
            Probe probe = new Probe(this._calc);
            if (ExpBackOffCallable.this._current.compareAndSet(this, probe)) {
                return probe.call();
            }
            return ((State)ExpBackOffCallable.this._current.get()).call();
        }

        void scheduleReset() {
            long backOff = this._calc.nextBackOffInterval();
            this._expTime = new Date(System.currentTimeMillis() + backOff);
            LOGGER.warn("Back off the execution of {} for {} milliseconds.", (Object)ExpBackOffCallable.this._call, (Object)backOff);
        }
    }

    private final class Running
    implements State<T> {
        private Running() {
        }

        @Override
        public T call() throws Exception {
            State current = (State)ExpBackOffCallable.this._current.get();
            if (this != current) {
                return current.call();
            }
            try {
                return ExpBackOffCallable.this._call.call();
            }
            catch (Exception exc) {
                if (ExpBackOffCallable.shouldDoBackOff(exc)) {
                    Error newState = new Error(exc);
                    if (ExpBackOffCallable.this._current.compareAndSet(this, newState)) {
                        newState.scheduleReset();
                    }
                }
                throw exc;
            }
        }
    }

    private static interface State<T>
    extends Callable<T> {
    }
}

