/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.utilities;

import java.lang.reflect.Array;
import java.util.AbstractList;

public class HashUtils {
    private static int PRIME = 31;
    private static int NULL_HASH = 0;

    public static int getHashCode(Object ... members) {
        int result = 1;
        for (Object m : members) {
            result *= PRIME;
            result += m == null ? NULL_HASH : HashUtils.getHash(m);
        }
        return result;
    }

    public static <T> boolean areEqual(T first, T second) {
        if (first == second) {
            return true;
        }
        if (first == null) {
            return second == null;
        }
        if (first.getClass().isArray()) {
            if (second == null || !second.getClass().isArray()) {
                return false;
            }
            return new HelperList(first).equals(new HelperList(second));
        }
        return first.equals(second);
    }

    private static int getHash(Object o) {
        if (o.getClass().isArray()) {
            return new HelperList(o).hashCode();
        }
        return o.hashCode();
    }

    public static class HelperList<T>
    extends AbstractList<T> {
        final Object _array;
        final int _len;

        HelperList(Object array) {
            if (array == null) {
                throw new IllegalArgumentException("array is null");
            }
            if (!array.getClass().isArray()) {
                throw new IllegalArgumentException(array.getClass() + " is not an array.");
            }
            this._array = array;
            this._len = Array.getLength(this._array);
        }

        @Override
        public T get(int index) {
            return (T)Array.get(this._array, index);
        }

        @Override
        public int size() {
            return this._len;
        }
    }
}

