/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.utilities.threadcontexthelpers;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.slf4j.MDC;

public final class LogContextSetter
implements Supplier<Object>,
Consumer<Object> {
    private final String _key;
    private final Object _value;

    public LogContextSetter(String key, Object value) {
        Validate.notEmpty((String)key, (String)"key");
        this._key = key;
        this._value = value;
    }

    @Override
    public void accept(Object prev) {
        if (prev == null) {
            MDC.remove((String)this._key);
            return;
        }
        MDC.put((String)this._key, (String)((String)prev));
    }

    @Override
    public Object get() {
        String prev = MDC.get((String)this._key);
        if (this._value == null) {
            MDC.remove((String)this._key);
        } else {
            MDC.put((String)this._key, (String)this._value.toString());
        }
        return prev;
    }
}

