/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.soap.XmlInputSource;
import com.vmware.vim.vmomi.core.soap.impl.CalendarHelper;
import com.vmware.vim.vmomi.core.soap.impl.XmlStreamReaderInputSource;
import com.vmware.vim.vmomi.core.soap.impl.marshaller.FieldHelper;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.ArrayStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.ComplexStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.Environment;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.SoapFaultContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.SoapFaultDetailValueContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.SoapFaultStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContextFactory;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.DataObjectFactory;
import com.vmware.vim.vmomi.core.types.ManagedObjectFactory;
import com.vmware.vim.vmomi.core.types.Util;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.binary.Base64;

public class UnmarshallerImpl
implements Unmarshaller {
    private static final QName DELETED_MARKER_ATTR = new QName("deleted");
    private static final Charset US_ASCII_CHARSET = Charset.forName("US-ASCII");
    private Environment _env;

    public UnmarshallerImpl(VmodlContext context, VmodlVersion version, DataObjectFactory dataObjectFactory, boolean resolveMoType, ManagedObjectFactory managedObjectFactory, boolean qsFormat) {
        this._env = new Environment(context, context.getVmodlTypeMap(), version, dataObjectFactory, resolveMoType, managedObjectFactory, qsFormat);
    }

    @Override
    public Object unmarshal(VmodlField field, XMLStreamReader source) throws XMLStreamException, UnmarshallException {
        return this.unmarshal(field, new XmlStreamReaderInputSource(source));
    }

    @Override
    public Object unmarshal(VmodlField field, XmlInputSource source) throws UnmarshallException {
        UnmarshallContext ctx = new UnmarshallContext(field, source);
        return ctx.unmarshall();
    }

    @Override
    public Exception unmarshalSoapFault(XMLStreamReader source) throws XMLStreamException, UnmarshallException {
        return this.unmarshalSoapFault(new XmlStreamReaderInputSource(source));
    }

    @Override
    public Exception unmarshalSoapFault(XmlInputSource source) throws UnmarshallException {
        UnmarshallSoapFaultContext ctx = new UnmarshallSoapFaultContext(source);
        return ctx.unmarshall();
    }

    private static Map<QName, String> getAttributes(XmlInputSource source) throws UnmarshallException {
        HashMap<QName, String> attrs = new HashMap<QName, String>(source.getAttributeCount());
        for (int index = 0; index < source.getAttributeCount(); ++index) {
            attrs.put(source.getAttributeName(index), source.getAttributeValue(index));
        }
        UnmarshallerImpl.validateElementAttributes(source, attrs);
        return attrs;
    }

    private static void validateElementAttributes(XmlInputSource source, Map<QName, String> attrs) throws UnmarshallException {
        if (attrs.containsKey(Constants.XSI_NIL_QNAME)) {
            throw new UnmarshallException(String.format("\nAttribute %1$s not allowed on element %2$s, which is not nillable.", Constants.XSI_NIL_QNAME, source.getName()));
        }
    }

    class UnmarshallContext {
        private VmodlField _rootField;
        private XmlInputSource _source;
        private Stack<StackContext> _stack;

        public UnmarshallContext(VmodlField field, XmlInputSource source) {
            this._rootField = field;
            this._source = source;
            this._stack = new Stack();
        }

        public Object unmarshall() throws UnmarshallException {
            StackContext result = this.parse();
            if (result == null) {
                return null;
            }
            return result.getValue();
        }

        public Object unmarshall(StackContext ctx) throws UnmarshallException {
            this._stack.push(ctx);
            StackContext result = this.parse(ctx);
            if (result == null) {
                return null;
            }
            return result.getValue();
        }

        private StackContext parse() throws UnmarshallException {
            return this.parse(null);
        }

        private void advanceNextSibling() throws UnmarshallException {
            int stackDepth = 1;
            while (stackDepth > 0) {
                int type = this._source.next();
                if (type == 1) {
                    ++stackDepth;
                    continue;
                }
                if (type != 2) continue;
                --stackDepth;
            }
        }

        private StackContext parse(StackContext initCtx) throws UnmarshallException {
            StackContext ctx;
            StackContext stackContext = ctx = initCtx == null ? this.primeStack() : initCtx;
            if (ctx == null) {
                return null;
            }
            StringBuilder buffer = null;
            if (this.expectingChars()) {
                buffer = new StringBuilder();
            }
            while (!this._stack.empty()) {
                int type = this._source.next();
                if (type != 4 && buffer != null) {
                    this.textValue(buffer.toString());
                    buffer = null;
                }
                switch (type) {
                    case 1: {
                        Map attrs = UnmarshallerImpl.getAttributes(this._source);
                        if (attrs.get(DELETED_MARKER_ATTR) != null) {
                            this.advanceNextSibling();
                            break;
                        }
                        this.beginElement(this._source.getName(), attrs);
                        if (!this.expectingChars()) break;
                        buffer = new StringBuilder();
                        break;
                    }
                    case 2: 
                    case 8: {
                        this.endElement();
                        break;
                    }
                    case 4: {
                        if (!this.expectingChars()) break;
                        if (buffer == null) {
                            buffer = new StringBuilder();
                        }
                        buffer.append(this._source.getText());
                    }
                }
            }
            return ctx;
        }

        private boolean expectingChars() {
            if (this._stack.isEmpty()) {
                return false;
            }
            StackContext ctx = this._stack.peek();
            switch (ctx.getType().getKind()) {
                case DATA_OBJECT: 
                case ARRAY: 
                case FAULT: {
                    return false;
                }
                case MOREF: 
                case MANAGED_OBJECT: 
                case URI: {
                    return !UnmarshallerImpl.this._env.isQSFormat();
                }
                case STRING: {
                    return !UnmarshallerImpl.this._env.isQSFormat() || !ctx.getField().isLink();
                }
            }
            return true;
        }

        private StackContext primeStack() throws UnmarshallException {
            Map attrs;
            if (this._source.getEventType() != 1) {
                this._source.nextTag();
            }
            if ((attrs = UnmarshallerImpl.getAttributes(this._source)).get(DELETED_MARKER_ATTR) != null) {
                this.advanceNextSibling();
                return null;
            }
            StackContext ctx = StackContextFactory.newContext(null, this._rootField, this._source.getName(), attrs, this._source.getNamespaceContext(), UnmarshallerImpl.this._env);
            if (ctx instanceof ArrayStackContext) {
                this._stack.push(ctx);
                if (ctx.getField().getType().getKind() != VmodlType.Kind.ANY) {
                    this._stack.push(ctx.getNestedContext(this._source.getName(), UnmarshallerImpl.getAttributes(this._source), this._source.getNamespaceContext()));
                }
            } else {
                this._stack.push(ctx);
            }
            return ctx;
        }

        private void beginElement(QName name2, Map<QName, String> attrs) throws UnmarshallException {
            StackContext parentCtx = this._stack.peek();
            StackContext nested = parentCtx.getNestedContext(name2, attrs, this._source.getNamespaceContext());
            if (nested == null && parentCtx instanceof ArrayStackContext) {
                if (parentCtx.getField().getType().getKind() != VmodlType.Kind.ANY) {
                    this._stack.pop().close();
                }
                if (this._stack.size() == 0) {
                    return;
                }
                parentCtx = this._stack.peek();
                nested = parentCtx.getNestedContext(name2, attrs, this._source.getNamespaceContext());
                if (nested == null) {
                    throw new UnmarshallException("Expected nested element not found");
                }
            }
            if (nested instanceof ArrayStackContext) {
                this._stack.push(nested);
                if (nested.getField().getType().getKind() != VmodlType.Kind.ANY) {
                    this._stack.push(nested.getNestedContext(name2, attrs, this._source.getNamespaceContext()));
                }
            } else {
                this._stack.push(nested);
            }
        }

        private void endElement() throws UnmarshallException {
            StackContext ctx = this._stack.pop();
            ctx.close();
            if (ctx instanceof ArrayStackContext && ctx.getField().getType().getKind() != VmodlType.Kind.ANY && !this._stack.empty()) {
                this._stack.pop().close();
            }
        }

        private Boolean parseBool(String bool) throws UnmarshallException {
            String lc = bool.toLowerCase();
            if (lc.equals("true") || lc.equals("1")) {
                return Boolean.TRUE;
            }
            if (lc.equals("false") || lc.equals("0")) {
                return Boolean.FALSE;
            }
            throw new UnmarshallException(String.format("Unexpected value parsing boolean. Expected values are 'true', '1', 'false', '0' but found %1$s", lc));
        }

        private void textValue(String value) throws UnmarshallException {
            StackContext ctx = this._stack.peek();
            switch (ctx.getType().getKind()) {
                case BOOL: {
                    ctx.setValue(this.parseBool(value.trim()));
                    break;
                }
                case BYTE: {
                    ctx.setValue(Byte.parseByte(value.trim()));
                    break;
                }
                case SHORT: {
                    ctx.setValue(Short.parseShort(value.trim()));
                    break;
                }
                case INT: {
                    ctx.setValue(Integer.parseInt(value.trim()));
                    break;
                }
                case LONG: {
                    ctx.setValue(Long.parseLong(value.trim()));
                    break;
                }
                case FLOAT: {
                    ctx.setValue(Float.valueOf(Float.parseFloat(value.trim())));
                    break;
                }
                case DOUBLE: {
                    ctx.setValue(Double.parseDouble(value.trim()));
                    break;
                }
                case TYPE_NAME: {
                    ctx.setValue(Util.createTypeName(value.trim(), UnmarshallerImpl.this._env.getContext(), UnmarshallerImpl.this._env.getService()));
                    break;
                }
                case METHOD_NAME: {
                    ctx.setValue(Util.createMethodName(value.trim(), UnmarshallerImpl.this._env.getContext(), UnmarshallerImpl.this._env.getService()));
                    break;
                }
                case MOREF: 
                case MANAGED_OBJECT: 
                case PROPERTY_PATH: {
                    ctx.setValue(value.trim());
                    break;
                }
                case STRING: {
                    ctx.setValue(value);
                    break;
                }
                case DATETIME: {
                    ctx.setValue(CalendarHelper.parseXsdDateTime(value.trim()));
                    break;
                }
                case URI: {
                    try {
                        ctx.setValue(new URI(value.trim()));
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new UnmarshallException(String.format("Failed to parse URI: %s", value));
                    }
                }
                case BINARY: {
                    ctx.setValue(new BinaryImpl(Base64.decodeBase64((byte[])value.getBytes(US_ASCII_CHARSET))));
                    break;
                }
                case ENUM: {
                    ctx.setValue(value.trim());
                    break;
                }
                default: {
                    throw new UnmarshallException(String.format("Unexpected type %1$s", new Object[]{ctx.getType().getKind()}));
                }
            }
        }
    }

    class UnmarshallSoapFaultContext {
        private XmlInputSource _source;
        private Stack<SoapFaultContext> _stack;

        public UnmarshallSoapFaultContext(XmlInputSource source) {
            this._source = source;
            this._stack = new Stack();
        }

        public Exception unmarshall() throws UnmarshallException {
            return this.parse();
        }

        private Exception parse() throws UnmarshallException {
            if (this._source.getEventType() != 1) {
                this._source.nextTag();
            }
            if (!this._source.getName().equals(Constants.FAULT_QNAME)) {
                throw new UnmarshallException(String.format("Unexpected element '%1$s'. Expected element is '%2$s'", this._source.getName(), Constants.FAULT_QNAME));
            }
            SoapFaultStackContext ctx = new SoapFaultStackContext();
            this._stack.push(ctx);
            StringBuilder buffer = null;
            while (!this._stack.empty()) {
                int type = this._source.next();
                if (type != 4 && buffer != null) {
                    String value = buffer.toString().trim();
                    if (value.length() > 0) {
                        SoapFaultContext parent = this._stack.peek();
                        parent.setValue(buffer.toString());
                    }
                    buffer = null;
                }
                switch (type) {
                    case 1: {
                        SoapFaultContext parent = this._stack.peek();
                        SoapFaultContext child = parent.getNestedContext(this._source.getName(), UnmarshallerImpl.getAttributes(this._source));
                        if (child instanceof SoapFaultDetailValueContext) {
                            String fieldTypeWsdlName = this._source.getName().getLocalPart().replaceAll("Fault$", "");
                            ComplexType fieldType = (ComplexType)UnmarshallerImpl.this._env.getTypeMap().getVmodlType(fieldTypeWsdlName, UnmarshallerImpl.this._env.getService());
                            if (fieldType == null) {
                                fieldType = (ComplexType)UnmarshallerImpl.this._env.getTypeMap().getVmodlType(fieldTypeWsdlName);
                            }
                            if (fieldType == null) {
                                fieldType = (ComplexType)UnmarshallerImpl.this._env.getTypeMap().getVmodlType(Exception.class);
                            }
                            FieldHelper.DataObjectWrapperField field = new FieldHelper.DataObjectWrapperField(fieldTypeWsdlName, fieldType, UnmarshallerImpl.this._env.getVersion());
                            ComplexStackContext complexStackCtx = new ComplexStackContext(field, StackContextFactory.getType(field, UnmarshallerImpl.getAttributes(this._source), this._source.getNamespaceContext(), UnmarshallerImpl.this._env), null, UnmarshallerImpl.this._env);
                            UnmarshallContext faultCtx = new UnmarshallContext(field, this._source);
                            child.setValue(faultCtx.unmarshall(complexStackCtx));
                            break;
                        }
                        this._stack.push(child);
                        break;
                    }
                    case 2: 
                    case 8: {
                        this._stack.pop();
                        break;
                    }
                    case 4: {
                        if (buffer == null) {
                            buffer = new StringBuilder();
                        }
                        buffer.append(this._source.getText());
                    }
                }
            }
            Exception e = ctx.getFault();
            if (e == null) {
                e = new RuntimeException(ctx.getMessage());
            }
            return e;
        }
    }
}

