/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.tracing;

import com.vmware.vim.vmomi.core.tracing.GlobalTracer;
import io.opentracing.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TracingFeature {
    public static final boolean ON;
    private static final String FEATURE_STATE_CLASS = "com.vmware.vim.featurestateswitch.FeatureState";
    private static final Log _logger;

    private TracingFeature() {
    }

    private static boolean isTracingOn() {
        try {
            if (!TracingFeature.isFeatureStateOn()) {
                _logger.info((Object)"OpenTracing feature is OFF");
                return false;
            }
            if (!_logger.isTraceEnabled()) {
                _logger.info((Object)"OpenTracing logger (com.vmware.vim.vmomi.core.tracing) is not enabled at TRACE level. Tracing data will not be reported.");
                return false;
            }
            Tracer tracer = GlobalTracer.get();
            _logger.info((Object)("Tracing is enabled:" + tracer));
            return true;
        }
        catch (Exception | NoClassDefFoundError e) {
            _logger.info((Object)"VLSI tracing is off");
            _logger.debug((Object)"Failed to initialize tracing", e);
            return false;
        }
    }

    private static boolean isFeatureStateOn() throws NoSuchMethodException, SecurityException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = Class.forName(FEATURE_STATE_CLASS);
        Method method = clazz.getMethod("getOpenTracing", null);
        return (Boolean)method.invoke(null, (Object[])null);
    }

    static {
        _logger = LogFactory.getLog(TracingFeature.class);
        ON = TracingFeature.isTracingOn();
    }
}

