/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.reactive.impl;

import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.CachingStream;
import com.vmware.srm.client.reactive.impl.StreamImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public class Streams {
    private static final Stream EMPTY = Streams.initEmptyStream();

    private static Stream initEmptyStream() {
        StreamImpl empty = new StreamImpl();
        empty.publishComplete();
        return empty;
    }

    public static <T> Stream<T> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public static <T> Stream<T> from(Publisher<? extends T> ... publishers) {
        return Streams.fromCollection(Arrays.asList(publishers));
    }

    public static <T> Stream<T> fromCollection(Collection<? extends Publisher<? extends T>> publishers) {
        if (publishers.isEmpty()) {
            return Streams.empty();
        }
        CachingStream<Publisher<T>> result = new CachingStream<Publisher<T>>();
        for (Publisher<T> publisher : publishers) {
            result.publishNext(publisher);
        }
        result.publishComplete();
        return result.flatMap(Function.identity());
    }

    public static <T> Stream<T> from(Collection<T> items) {
        if (items.isEmpty()) {
            return Streams.empty();
        }
        CachingStream<T> result = new CachingStream<T>();
        for (T item : items) {
            result.publishNext(item);
        }
        result.publishComplete();
        return result;
    }

    @SafeVarargs
    public static <T> Stream<T> just(T ... items) {
        return Streams.from(Arrays.asList(items));
    }
}

