/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.srm.client.infrastructure.authentication.data.LoginServerData;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.GetTopology;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;

@DrInputType(value=LoginServerData.class)
public class PairLoginDataHandler
implements FreeRequestHandler {
    @Override
    public Promise<DrData> handle(DrData input, FreeRequestContext context) {
        LoginServerData loginData = (LoginServerData)input;
        Topology topology = ((GetTopology)((Object)context)).get();
        ExtensionServersView view = (ExtensionServersView)context.view();
        return this.loginToVc((ServersView)view, loginData, topology);
    }

    private Promise<DrData> loginToVc(ServersView view, LoginServerData loginData, Topology topology) {
        return view.getServerBy(loginData.getGuid()).materialize().thenCompose(serverResult -> {
            if (serverResult.isSuccessful()) {
                return Promises.resolve((Object)DrData.EMPTY);
            }
            if (serverResult.getError() instanceof ExtensionServersView.ServerByPairSetupException) {
                ExtensionServersView.ServerByPairSetupException sbpsExc = (ExtensionServersView.ServerByPairSetupException)serverResult.getError();
                PairSetup<?> ps = this.pick(sbpsExc);
                if (ps == null) {
                    return Promises.reject((Exception)new RuntimeException(L10N.localize("noEligiblePairSetup", loginData.getGuid())));
                }
                return topology.loginPair(ps, loginData.getUser(), loginData.getPassword()).thenApply(unused -> DrData.EMPTY);
            }
            return Promises.reject((Exception)serverResult.getError());
        });
    }

    private PairSetup<?> pick(ExtensionServersView.ServerByPairSetupException sbpsExc) {
        for (PairSetup ps : sbpsExc.getPairSetups()) {
            Exception cause = sbpsExc.getCause(ps);
            if (!(cause instanceof NotAuthenticated)) continue;
            return ps;
        }
        return null;
    }
}

