/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.srm.client.utilities.ThreadContext;
import com.vmware.srm.client.utilities.threadcontexthelpers.LogContextSetter;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SessionInfo {
    private static final String DIAGNOSTIC_USERNAME = "drUsername";
    private static final String DIAGNOSTIC_SESSION_ID = "drSessionIdAlias";
    private static final ThreadLocal<SessionInfo> SESSION_DATA = ThreadLocal.withInitial(() -> new SessionInfo("UNKNOWN", "UNKNOWN_SESSION_ID"));
    private final String _username;
    private final String _sessionIdHash;

    static <T> T executeWithSessionData(SessionInfo sessionInfo, Callable<T> task) throws Exception {
        LogContextSetter lcsSessionId = new LogContextSetter(DIAGNOSTIC_SESSION_ID, (Object)sessionInfo.getSessionIdHash());
        Callable<T> chainedTask = SessionInfo.wrapInContext(task, lcsSessionId);
        LogContextSetter lcsUsername = new LogContextSetter(DIAGNOSTIC_USERNAME, (Object)sessionInfo.getUsername());
        chainedTask = SessionInfo.wrapInContext(chainedTask, lcsUsername);
        return (T)ThreadContext.extendContext(chainedTask, () -> {
            SessionInfo current = SESSION_DATA.get();
            SESSION_DATA.set(sessionInfo);
            return current;
        }, prev -> SESSION_DATA.set((SessionInfo)prev));
    }

    private static <T> Callable<T> wrapInContext(Callable<T> call, LogContextSetter lcs) {
        return () -> ThreadContext.extendContext((Callable)call, (Supplier)lcs, (Consumer)lcs);
    }

    public static SessionInfo getSessionData() {
        return SESSION_DATA.get();
    }

    public String getUsername() {
        return this._username;
    }

    public String getSessionIdHash() {
        return this._sessionIdHash;
    }

    SessionInfo(String username, String sessionIdHash) {
        this._username = username;
        this._sessionIdHash = sessionIdHash;
    }
}

