/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.websso;

import com.vmware.srm.client.infrastructure.authentication.AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import com.vmware.srm.client.infrastructure.authentication.websso.WebSsoLoginServlet;
import com.vmware.srm.client.infrastructure.authentication.websso.WebSsoLogoutServlet;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebSsoAuthenticationStrategy
implements AuthenticationStrategy {
    private final SsoContext _webSsoContext;

    public WebSsoAuthenticationStrategy(SsoContext webSsoContext) {
        this._webSsoContext = webSsoContext;
    }

    @Override
    public Promise<Void> startLogin(HttpServletRequest request, HttpServletResponse response, String redirectPath) throws IOException {
        WebSsoLoginServlet.LoginImpl login;
        if (AuthenticationUtils.isAuthenticated(request)) {
            String msg = L10N.localize("sessionAlreadyAuthenticated", new Object[0]);
            response.sendError(400, msg);
            return Promises.reject((Exception)new RuntimeException(msg));
        }
        try {
            login = new WebSsoLoginServlet.LoginImpl(this._webSsoContext);
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
        try {
            login.start(request, response, redirectPath);
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
        return Promises.resolve(null);
    }

    @Override
    public Promise<Void> startLogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            response.sendError(401);
            return Promises.reject((Exception)new RuntimeException(L10N.localize("sessionNotAuthenticated", new Object[0])));
        }
        String username = SessionWrapper.getUsername(session);
        String sessionIndex = SessionWrapper.getSessionIndex(session);
        AuthenticationUtils.destroySession(session);
        WebSsoLogoutServlet.LogoutImpl logout = new WebSsoLogoutServlet.LogoutImpl(this._webSsoContext);
        logout.start(request, response, username, sessionIndex);
        return Promises.resolve(null);
    }

    SsoContext getSsoContext() {
        return this._webSsoContext;
    }
}

