/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.dataHandlers;

import com.vmware.srm.client.infrastructure.dataHandlers.data.PairSitesNames;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.providers.SitesNameProvider;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.SrmRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.SrmRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.List;

@DrInputType
public class SrmSitesNameDataHandler
implements SrmRequestHandler {
    @Override
    public Promise<PairSitesNames> handle(DrData input, SrmRequestContext context) {
        PropertyCollector.FilterSpec filter = PCUtil.createFilterSpec(this.getObjectSpec(((SrmServer)context.extServer()).guid()), this.getPropertySpecs());
        Promise<PcResult> resultPromise = PCUtil.retrieveProperties(context.view(), new PropertyCollector.FilterSpec[]{filter});
        return resultPromise.thenApply(pcResult -> {
            SitesNameProvider.SitesNamesResult sitesNames = SitesNameProvider.getResult(pcResult);
            PairSitesNames pairSites = new PairSitesNames();
            pairSites.setLocalSiteName(sitesNames.localSiteName);
            pairSites.setLocalSiteRef(sitesNames.localSiteRef);
            pairSites.setRemoteSiteName(sitesNames.remoteSiteName);
            pairSites.setRemoteSiteRef(sitesNames.remoteSiteRef);
            return pairSites;
        });
    }

    private PropertyCollector.ObjectSpec[] getObjectSpec(String guid) {
        ManagedObjectReference serviceInstanceMoRef = ClientUtils.createMoRef((String)"DrServiceInstance", (String)"DrServiceInstance", (String)guid);
        return new PropertyCollector.ObjectSpec[]{SitesNameProvider.getObjectSpecs(serviceInstanceMoRef)};
    }

    private PropertyCollector.PropertySpec[] getPropertySpecs() {
        List<PropertyCollector.PropertySpec> propertySpecs = SitesNameProvider.getPropertySpecs();
        return propertySpecs.toArray(new PropertyCollector.PropertySpec[propertySpecs.size()]);
    }
}

