/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.dataHandlers;

import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.dataHandlers.data.PairSitesNames;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.SrmRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.SrmRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.vc.VcService;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DrInputType
public class VcSitesNameDataHandler
implements SrmRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VcSitesNameDataHandler.class);

    @Override
    public Promise<? extends DrData> handle(DrData input, SrmRequestContext context) {
        SrmServer srmServer = (SrmServer)context.extServer();
        LOGGER.trace("Getting local and remote VCenter server names for: [{}].", (Object)srmServer.guid());
        return ((SrmPairSetup)context.pairSetup()).getPairServer().thenCompose(pairSrmServer -> this.getVcNames(srmServer.vc(), pairSrmServer.vc()));
    }

    private Promise<PairSitesNames> getVcNames(VcServer localVcServer, VcServer remoteVcServer) {
        Promise<Consumer<PairSitesNames>> localVcRefConsumer = this.getLocalVcRefConsumer(localVcServer);
        Promise<Consumer<PairSitesNames>> remoteVcRefConsumer = this.getRemoteVcRefConsumer(remoteVcServer);
        Promise<Consumer<PairSitesNames>> localVcNameConsumer = this.getVcLocalSiteNameConsumer(localVcServer);
        Promise<Consumer<PairSitesNames>> remoteVcNameConsumer = this.getVcRemoteSiteNameConsumer(remoteVcServer);
        Stream stream = Streams.from((Publisher[])new Publisher[]{localVcNameConsumer, remoteVcNameConsumer, localVcRefConsumer, remoteVcRefConsumer});
        PairSitesNames siteName = new PairSitesNames();
        return stream.reduce((Object)siteName, (data, consumer) -> {
            consumer.accept(data);
            return data;
        });
    }

    private Promise<Consumer<PairSitesNames>> getLocalVcRefConsumer(VcServer server) {
        return ((VcService)server.service()).getContent().thenApply(ServiceInstanceContent::getRootFolder).thenApply(ref -> pairSiteNames -> pairSiteNames.setLocalSiteRef(new MoRefData((ManagedObjectReference)ref)));
    }

    private Promise<Consumer<PairSitesNames>> getRemoteVcRefConsumer(VcServer server) {
        return ((VcService)server.service()).getContent().thenApply(content -> content.rootFolder).thenApply(ref -> pairSiteNames -> pairSiteNames.setRemoteSiteRef(new MoRefData((ManagedObjectReference)ref)));
    }

    private Promise<Consumer<PairSitesNames>> getVcLocalSiteNameConsumer(VcServer server) {
        return server.getName().thenApply(name -> pairSiteNames -> pairSiteNames.setLocalSiteName((String)name));
    }

    private Promise<Consumer<PairSitesNames>> getVcRemoteSiteNameConsumer(VcServer server) {
        return server.getName().thenApply(name -> pairSiteNames -> {
            String remoteName = name;
            if (StringUtils.isEmpty((String)name)) {
                remoteName = L10N.localize("notAvailable", new Object[0]);
            }
            pairSiteNames.setRemoteSiteName(remoteName);
        });
    }
}

