/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.health;

import com.vmware.srm.client.infrastructure.health.HealthData;
import com.vmware.srm.client.infrastructure.health.SuTokenChecker;
import com.vmware.srm.client.infrastructure.health.WebSSORegChecker;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.infrastructure.init.workflow.DrInitException;
import com.vmware.srm.client.infrastructure.init.workflow.Status;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.PromiseResult;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.utilities.ExecuteOnceOpWrapper;
import com.vmware.srm.client.utilities.ExecutorUtils;
import com.vmware.vim.sso.client.exception.AuthenticationFailedException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class HealthChecker {
    private final Configurator _initConfig;
    private static final long UPDATE_PERIOD = 20L;
    private static final ScheduledExecutorService SCHED_EXEC = ExecutorUtils.getScheduledExecutor();
    private volatile ExecuteOnceOpWrapper<Promise<HealthData>> _opWrapper;

    public HealthChecker(Configurator initConfig) {
        this._initConfig = initConfig;
        this.initOpWrapper();
    }

    public Promise<HealthData> check() {
        return (Promise)this._opWrapper.invoke().get();
    }

    private Promise<HealthData> doCheck() {
        return this._initConfig.getOAuth2Strategy().thenCompose(unused -> this._initConfig.getSsoContext()).materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return this.doCheck((SsoContext)pr.getResult());
            }
            Exception exc = pr.getError();
            if (exc instanceof DrInitException) {
                return Promises.resolve((Object)this.getHealthData((DrInitException)exc));
            }
            return Promises.resolve((Object)this.getHealthData(Status.CONFIG_ERROR, exc));
        });
    }

    private Promise<HealthData> doCheck(SsoContext context) {
        Promise<Boolean> checkSuToken = new SuTokenChecker().doCheck(context);
        Promise<Boolean> checkWebSso = new WebSSORegChecker().doCheck(context);
        return Promises.allWithException((Promise[])new Promise[]{checkSuToken, checkWebSso}).thenApply(resultAccess -> {
            PromiseResult checkSuResult = resultAccess.getResult(checkSuToken);
            Exception exc = checkSuResult.getError();
            if (exc != null) {
                if (exc.getCause() instanceof AuthenticationFailedException) {
                    return this.getHealthData(Status.SU_TOKEN_ERROR, exc);
                }
                return this.getHealthData(Status.PSC_ERROR, exc);
            }
            PromiseResult checkWebResult = resultAccess.getResult(checkWebSso);
            exc = checkWebResult.getError();
            if (exc != null) {
                return this.getHealthData(Status.WEB_SSO_ERROR, exc);
            }
            return new HealthData(Status.OK.get(), Status.OK.getMsg());
        });
    }

    private HealthData getHealthData(Status s, Exception exc) {
        return new HealthData(s.get(), s.getMsg() + " Cause: " + exc);
    }

    private HealthData getHealthData(DrInitException drInitExc) {
        return new HealthData(drInitExc.statusCode, drInitExc.getMessage() + " Cause: " + drInitExc.getCause());
    }

    private void initOpWrapper() {
        this._opWrapper = new ExecuteOnceOpWrapper(() -> {
            Promise<HealthData> result = this.doCheck();
            result.materialize().onSuccess(unused -> SCHED_EXEC.schedule(() -> {
                this.initOpWrapper();
                return null;
            }, 20L, TimeUnit.SECONDS));
            return result;
        });
    }
}

