/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http.io;

import com.vmware.srm.client.infrastructure.http.io.AsyncClientUtils;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.PromiseImpl;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

public class HttpResponseController {
    public static Promise<HttpResponse> doGet(URI url, KeyStore sslStore, ThumbprintVerifier verifier) {
        Validate.notNull((Object)url, (String)"url");
        HttpGet request = new HttpGet(url);
        CloseableHttpAsyncClient http = AsyncClientUtils.createClient(sslStore, verifier);
        return HttpResponseController.doRequest((HttpUriRequest)request, http);
    }

    public static Promise<HttpResponse> doPost(HttpPost post, KeyStore sslStore, ThumbprintVerifier verifier) {
        CloseableHttpAsyncClient http = AsyncClientUtils.createClient(sslStore, verifier);
        return HttpResponseController.doRequest((HttpUriRequest)post, http);
    }

    private static Promise<HttpResponse> doRequest(HttpUriRequest request, CloseableHttpAsyncClient http) {
        try {
            http.start();
            HttpResponsePromise result = new HttpResponsePromise();
            http.execute(request, (FutureCallback)result);
            result.materialize().onSuccess(ununsed -> {
                try {
                    http.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return result;
        }
        catch (RuntimeException e) {
            try {
                http.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    static final class HttpResponsePromise
    extends PromiseImpl<HttpResponse>
    implements FutureCallback<HttpResponse> {
        HttpResponsePromise() {
        }

        public void cancelled() {
            this.setError(new CancellationException());
        }

        public void completed(HttpResponse result) {
            this.setResult(result);
        }

        public void failed(Exception exc) {
            this.setError(exc);
        }
    }
}

