/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.phonehome;

import com.vmware.srm.client.infrastructure.websso.LsppQuery;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.vmomi.ph.PhServiceImpl;
import com.vmware.srm.client.utilities.Exceptions;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.phonehome.data.ConsentConfiguration;
import com.vmware.vim.binding.phonehome.data.ConsentConfigurationData;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhUtils.class);
    private static final int vSPHERE_CONSENT_ID = 2;
    private static final ServiceRegistration.EndpointType PH_EP = new ServiceRegistration.EndpointType("", "com.vmware.ph.globalconfig.consentservice");
    private static final ServiceRegistration.EndpointType LICENSE_EP = new ServiceRegistration.EndpointType("", "com.vmware.cis.cs.license.sdk");
    private static final String LICENSE_PATH = "/ls/sdk";
    private static final String LEGACY_PH_PATH = "/ls/ph/sdk";

    private static ServiceRegistration.Filter createFilter(String siteId, ServiceRegistration.EndpointType endpointType) {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setSiteId(siteId);
        filter.setEndpointType(endpointType);
        return filter;
    }

    public static Promise<Boolean> getCeipEnabled() {
        LsppQuery lq = new LsppQuery(Config.get().getLsppUrl(), Config.get().getLsppThumbprint());
        Promise<Set<LsppService>> phSet = lq.query(PhUtils.createFilter(null, PH_EP));
        Promise<Set<LsppService>> licenseSet = lq.query(PhUtils.createFilter(null, LICENSE_EP));
        Promise result = phSet.thenCompose(phRegs -> {
            if (phRegs.isEmpty()) {
                return licenseSet.thenCompose(PhUtils::getEnabledFromLicense);
            }
            return PhUtils.getEnabledFromPh(phRegs);
        });
        result.materialize().onSuccess(unused -> lq.dispose());
        return result;
    }

    private static Promise<Boolean> getCeipEnabled(URI phUrl, KeyStore keyStore) {
        PhServiceImpl service = new PhServiceImpl(phUrl, keyStore);
        Promise result = service.getContent().thenApply(PhUtils::computeEnabled);
        result.materialize().onSuccess(unused -> service.dispose());
        return result;
    }

    private static boolean computeEnabled(ConsentConfigurationData consentData) {
        LOGGER.trace("Retrieved following data:\n{}", (Object)consentData);
        if (consentData == null) {
            return false;
        }
        Object[] configs = consentData.getConsentConfigurations();
        if (ArrayUtils.isEmpty((Object[])configs)) {
            return false;
        }
        Optional<ConsentConfiguration> result = Arrays.stream(configs).filter(config -> 2 == config.consentId).findFirst();
        return result.isPresent() && result.get().consentAccepted;
    }

    private static Promise<Boolean> getEnabledFromLicense(Set<LsppService> licenseRegs) {
        LOGGER.trace("Getting 'ceipEnabled' from License:\n{}.", licenseRegs);
        if (licenseRegs.isEmpty()) {
            return Promises.resolve((Object)false);
        }
        LsppService lr = licenseRegs.iterator().next();
        for (LsppServiceEndpoint ep : lr.getEndpoints()) {
            URI phUrl;
            if (!LICENSE_PATH.equals(ep.url.getPath())) continue;
            LOGGER.trace("Using endpoint:\n'{}'", (Object)ep);
            KeyStore store = PhUtils.createKeyStore(ep);
            URI lcUrl = ep.url;
            try {
                phUrl = new URI(lcUrl.getScheme(), null, lcUrl.getHost(), lcUrl.getPort(), LEGACY_PH_PATH, null, null);
            }
            catch (URISyntaxException e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
            return PhUtils.getCeipEnabled(phUrl, store);
        }
        LOGGER.warn("No compatible endpoint found: {}", (Object)lr.getEndpoints());
        return Promises.resolve((Object)false);
    }

    private static Promise<Boolean> getEnabledFromPh(Set<LsppService> phRegs) {
        LOGGER.trace("Getting 'ceipEnabled' from PH ConsentService:\n{}.", phRegs);
        if (phRegs.isEmpty()) {
            return Promises.resolve((Object)false);
        }
        LsppService pr = phRegs.iterator().next();
        if (pr.getEndpoints().isEmpty()) {
            LOGGER.warn("No compatible endpoint found for '{}'", (Object)pr);
            return Promises.resolve((Object)false);
        }
        LsppServiceEndpoint ep = (LsppServiceEndpoint)pr.getEndpoints().iterator().next();
        return PhUtils.getCeipEnabled(ep.url, PhUtils.createKeyStore(ep));
    }

    private static KeyStore createKeyStore(LsppServiceEndpoint ep) {
        KeyStore store;
        try {
            store = CertificateUtils.createTrustStore((Collection)ep.getCertificates());
        }
        catch (IOException | GeneralSecurityException e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
        return store;
    }
}

