/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.providers;

import com.vmware.srm.client.infrastructure.commonData.InventoryData;
import com.vmware.srm.client.infrastructure.commonData.MoRefData;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.providers.PCInventoryProvider;
import com.vmware.srm.client.infrastructure.related.RelatedObjectsProvider;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrDataList;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.Stream;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class FolderRelatedChildrenProvider
implements RelatedObjectsProvider<MoRefData, InventoryData> {
    private ServersView _view;
    private PCInventoryProvider<InventoryData>[] _providers;

    public FolderRelatedChildrenProvider(ServersView view, PCInventoryProvider<InventoryData>[] providers) {
        if (providers == null) {
            throw new IllegalArgumentException("No providers provided!");
        }
        this._view = view;
        this._providers = providers;
    }

    @Override
    public Promise<? extends Collection<InventoryData>> getRelatedObjects(MoRefData source) {
        Promise childrenPromise = PCUtil.retrieveProperty(this._view, source, "childEntity");
        return childrenPromise.thenCompose(children -> {
            if (((ManagedObjectReference[])children).length == 0) {
                return Promises.resolve(new DrDataList());
            }
            PropertyCollector.FilterSpec filterSpec = PCUtil.createFilterSpec(this.getObjectSpecs(Arrays.asList(children)), this.getFilterSpecs());
            Promise<PcResult> childProvidersInfo = PCUtil.retrieveProperties(this._view, filterSpec);
            return childProvidersInfo.thenCompose(pcResult -> this.handle((PcResult)pcResult).collect()).thenApply(items -> {
                DrDataList result = new DrDataList();
                result.addAll(items);
                return result;
            });
        });
    }

    private Collection<PropertyCollector.ObjectSpec> getObjectSpecs(Collection<ManagedObjectReference> moRefs) {
        Collection objSpecs = moRefs.stream().map(moref -> new ObjectSpecBuilder((ManagedObjectReference)moref).build()).collect(Collectors.toList());
        for (PCInventoryProvider<InventoryData> provider : this._providers) {
            objSpecs.addAll(provider.getObjectSpec(moRefs));
        }
        return objSpecs;
    }

    private PropertyCollector.PropertySpec[] getFilterSpecs() {
        ArrayList<PropertyCollector.PropertySpec> propertySpecs = new ArrayList<PropertyCollector.PropertySpec>();
        for (PCInventoryProvider<InventoryData> provider : this._providers) {
            propertySpecs.addAll(provider.getPropertySpec());
        }
        return propertySpecs.toArray(new PropertyCollector.PropertySpec[propertySpecs.size()]);
    }

    private Stream<? extends InventoryData> handle(PcResult pcResult) {
        Stream data = Streams.empty();
        for (PCInventoryProvider<InventoryData> provider : this._providers) {
            data = data.merge(new Publisher[]{provider.getResult(pcResult, this._view)});
        }
        return data;
    }
}

