/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.datasource.impl;

import com.vmware.srm.client.infrastructure.requestHandlers.DrRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.DrRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FilterSortPageContext;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.DrPagedResponse;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.FilterData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.FilterSortPageHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.FilterSortPageHandlerException;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.PageData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.SortData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.SortOrder;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.impl.DrPagedResponseImpl;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrDataList;
import com.vmware.srm.client.reactive.Promise;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.PropertyUtils;

public class FilterSortPageResponseProcessor<T extends DrRequestContext<?> & FilterSortPageContext, V extends DrRequestContext<?>>
implements DrRequestHandler<T>,
FilterSortPageHandler<T> {
    private final DrRequestHandler<V> _delegate;

    public FilterSortPageResponseProcessor(DrRequestHandler<V> delegate) {
        this._delegate = delegate;
    }

    @Override
    public Promise<? extends DrPagedResponse<? extends DrData>> handle(DrData input, T context) {
        return this._delegate.handle(input, context).thenApply(data -> this.apply((DrData)data, context)).materialize().thenApply(pr -> {
            if (pr.isSuccessful()) {
                return (DrPagedResponse)pr.getResult();
            }
            throw new FilterSortPageHandlerException(pr.getError());
        });
    }

    private DrPagedResponse<? extends DrData> apply(DrData handlerResult, T context) {
        if (!(handlerResult instanceof DrDataList)) {
            throw new IllegalArgumentException("filter/page/sort not supported by '" + this._delegate + "'");
        }
        DrDataList data = (DrDataList)handlerResult;
        List transformedData = this.applySort(this.applyFilter(data.stream(), context), context).collect(Collectors.toList());
        DrDataList dataList = new DrDataList();
        this.applyPaging(transformedData.stream(), context).forEach(obj -> dataList.add(obj));
        return new DrPagedResponseImpl(dataList, transformedData.size());
    }

    private Stream<? extends DrData> applySort(Stream<? extends DrData> dataStream, T context) {
        SortData sortRequestData = ((FilterSortPageContext)context).getSortData();
        if (sortRequestData == null) {
            return dataStream;
        }
        String prop = sortRequestData.getSortProperty();
        SortOrder order = sortRequestData.getSortOrder();
        return dataStream.sorted(order.apply((obj1, obj2) -> {
            Comparable<?> prop1 = this.getObjectProperty((DrData)obj1, prop);
            Comparable<?> prop2 = this.getObjectProperty((DrData)obj2, prop);
            if (prop1 == null) {
                return prop2 == null ? 0 : -1;
            }
            if (prop2 == null) {
                return 1;
            }
            return prop1.compareTo(prop2);
        }));
    }

    private Stream<? extends DrData> applyFilter(Stream<? extends DrData> dataStream, T context) {
        FilterData filterData = ((FilterSortPageContext)context).getFilterData();
        if (filterData == null) {
            return dataStream;
        }
        String filterValue = filterData.getFilterValue().toLowerCase();
        return dataStream.filter(obj -> {
            Comparable<?> propValue = this.getObjectProperty((DrData)obj, filterData.getFilterProperty());
            if (propValue == null) {
                return false;
            }
            return propValue.toString().toLowerCase().contains(filterValue);
        });
    }

    private Stream<? extends DrData> applyPaging(Stream<? extends DrData> dataStream, T context) {
        PageData pageRequestData = ((FilterSortPageContext)context).getPageData();
        if (pageRequestData == null) {
            return dataStream;
        }
        dataStream = dataStream.skip(pageRequestData.getStartIndex()).limit(pageRequestData.getPageSize());
        return dataStream;
    }

    private Comparable<?> getObjectProperty(DrData object, String property) {
        try {
            return (Comparable)PropertyUtils.getProperty((Object)object, (String)property);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No property found: " + property, e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot read property: " + property, e);
        }
    }
}

