/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.srm.client.infrastructure.tasks.ComposableTask;
import com.vmware.srm.client.infrastructure.tasks.TaskUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Queue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;

public class SequentialTasksExecutor {
    public static ManagedObjectReference runTasks(Queue<ComposableTask> tasks, Service<?, ?> service) {
        Validate.notEmpty(tasks, (String)"Tasks queue");
        return TaskUtil.toFakeTask(() -> SequentialTasksExecutor.doRunTasks(tasks, service))._getRef();
    }

    private static Promise<ManagedObjectReference> doRunTasks(Queue<ComposableTask> tasks, Service<?, ?> service) {
        if (CollectionUtils.isEmpty(tasks)) {
            return Promises.resolve(null);
        }
        try {
            Promise<ManagedObjectReference> taskResult = tasks.poll().run();
            if (tasks.size() == 0) {
                return taskResult;
            }
            return taskResult.thenCompose(task -> TaskUtil.waitForTaskToFinish(service, task)).thenCompose(result -> SequentialTasksExecutor.doRunTasks(tasks, service));
        }
        catch (Exception ex) {
            return Promises.reject((Exception)ex);
        }
    }
}

