/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.utilities.L10NHelper;
import java.text.NumberFormat;
import java.util.Locale;

public class UnitFormatUtil {
    private static final int MS_PER_MINUTE = 60000;
    private static final int MS_PER_HOUR = 3600000;
    private static final int MS_PER_DAY = 86400000;
    public static final int AUTO = -1;
    public static final long UNIT_FACTOR_B = 1024L;
    public static final long B = 1L;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;

    public static String formatTimeSpan(long diffTime, boolean showMilliseconds) {
        long currentRemainingTime = diffTime;
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        if (currentRemainingTime >= 86400000L) {
            days = currentRemainingTime / 86400000L;
            currentRemainingTime %= 86400000L;
        }
        if (currentRemainingTime >= 3600000L) {
            hours = currentRemainingTime / 3600000L;
            currentRemainingTime %= 3600000L;
        }
        if (currentRemainingTime >= 60000L) {
            minutes = currentRemainingTime / 60000L;
            currentRemainingTime %= 60000L;
        }
        seconds = currentRemainingTime / 1000L;
        String elapsedTime = days > 0L ? L10N.localize("daysStringFormat", days, hours, minutes, seconds) : (hours > 0L ? L10N.localize("hoursStringFormat", hours, minutes, seconds) : (minutes > 0L ? L10N.localize("minutesStringFormat", minutes, seconds) : (seconds > 0L ? L10N.localize("secondsStringFormat", seconds) : (showMilliseconds ? L10N.localize("msStringFormat", currentRemainingTime) : L10N.localize("secondsStringFormat", seconds)))));
        return elapsedTime;
    }

    public static String formatStorage(double value, int precision, long valueUnit, long targetUnit, boolean includeLabel) {
        value *= (double)valueUnit;
        String label = UnitFormatUtil.getStorageLabel(1L);
        if (targetUnit == -1L) {
            if (value >= 1.099511627776E12) {
                value /= 1.099511627776E12;
                label = UnitFormatUtil.getStorageLabel(0x10000000000L);
            } else if (value >= 1.073741824E9) {
                value /= 1.073741824E9;
                label = UnitFormatUtil.getStorageLabel(0x40000000L);
            } else if (value >= 1048576.0) {
                value /= 1048576.0;
                label = UnitFormatUtil.getStorageLabel(0x100000L);
            } else if (value >= 1024.0) {
                value /= 1024.0;
                label = UnitFormatUtil.getStorageLabel(1024L);
            }
        } else {
            value /= (double)targetUnit;
            label = UnitFormatUtil.getStorageLabel(targetUnit);
        }
        Locale fmtLocale = L10NHelper.getLocale();
        NumberFormat formatter = NumberFormat.getInstance(fmtLocale);
        formatter.setMaximumFractionDigits(precision);
        formatter.setMinimumFractionDigits(precision);
        String returnString = formatter.format(value);
        if (includeLabel) {
            returnString = returnString + " " + label;
        }
        return returnString;
    }

    private static String getStorageLabel(long targetUnit) {
        if (targetUnit == 0x10000000000L) {
            return L10N.localize("teraByte.label", new Object[0]);
        }
        if (targetUnit == 0x40000000L) {
            return L10N.localize("gigaByte.label", new Object[0]);
        }
        if (targetUnit == 0x100000L) {
            return L10N.localize("megaByte.label", new Object[0]);
        }
        if (targetUnit == 1024L) {
            return L10N.localize("kiloByte.label", new Object[0]);
        }
        if (targetUnit == 1L) {
            return L10N.localize("byte.label", new Object[0]);
        }
        return "?";
    }
}

