/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.vapi;

import com.vmware.srm.client.topology.impl.vmomi.vlsi.SslTrust;
import com.vmware.srm.client.utilities.Disposable;
import com.vmware.srm.client.utilities.ExecutorUtils;
import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.cis.authn.ProtocolFactory;
import com.vmware.vapi.protocol.ClientConfiguration;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vapi.protocol.ProtocolConnection;
import java.net.URI;
import java.security.KeyStore;

public class VapiServiceImpl
implements Disposable {
    private static final int IO_THREAD_COUNT = 8;
    private final ProtocolConnection _connection;
    private final StubFactory _stubFactory;

    public VapiServiceImpl(URI url, KeyStore sslStore, int connectTimeoutMillis, int socketTimeoutMillis) {
        HttpConfiguration.SslConfiguration sslConfig = new HttpConfiguration.SslConfiguration.Builder().setTrustStore((KeyStore)SslTrust.get((KeyStore)sslStore).second()).getConfig();
        HttpConfiguration httpConfig = new HttpConfiguration.Builder().setSslConfiguration(sslConfig).setConnectTimeout(connectTimeoutMillis).setSoTimeout(socketTimeoutMillis).setLibraryType(HttpConfiguration.LibType.APACHE_HTTP_ASYNC_CLIENT).setIoThreadCount(8).getConfig();
        ClientConfiguration clientConfig = new ClientConfiguration.Builder().setExecutor(ExecutorUtils.getExecutor()).getConfig();
        this._connection = new ProtocolFactory().getHttpConnection(url.toString(), clientConfig, httpConfig);
        this._stubFactory = new StubFactory(this._connection.getApiProvider());
    }

    public <T extends Service> T createStub(Class<T> vapiService) {
        return (T)this._stubFactory.createStub(vapiService);
    }

    public void dispose() {
        this._connection.disconnect();
    }
}

