/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders.plans;

import com.vmware.srm.client.impex.configurables.mappings.RecoveryTestNetworkMappingConverter;
import com.vmware.srm.client.impex.configurables.plans.IeRecoveryPlan;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.dr.recovery.RecoveryManager;
import com.vmware.vim.binding.dr.recovery.RecoveryPlan;
import com.vmware.vim.binding.dr.recovery.RecoveryPlanSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanNetworkMappingsUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanNetworkMappingsUpdater.class);
    private final boolean _local;
    private final InventoryExtractor.InventoryLookup _inventory;
    private final PcResult _basicRpsPcResult;

    public PlanNetworkMappingsUpdater(boolean local, InventoryExtractor.InventoryLookup inventory, PcResult basicRpsPcResult) {
        this._local = local;
        this._inventory = inventory;
        this._basicRpsPcResult = basicRpsPcResult;
    }

    public Promise<Void> updateRecoveryPlan(IeRecoveryPlan ieRecoveryPlan, ManagedObjectReference planMoRef) {
        LOGGER.info("Updating test network mappings for recovery plan '{}' with moRef '{}'", (Object)ieRecoveryPlan.getName(), (Object)planMoRef);
        RecoveryPlanSpec planSpec = this.buildUpdateSpec(ieRecoveryPlan, planMoRef);
        FuturePromise futurePromise = new FuturePromise();
        RecoveryManager rm = (RecoveryManager)IContextUtil.getSrmService(this._local).createStub(IContextUtil.getSrmContent(this._local).getRecoveryManager());
        rm.reconfigurePlan(planMoRef, planSpec, (Future)futurePromise);
        return futurePromise.thenCompose(taskMoRef -> ImpexImportSrmContext.get().monitor((ManagedObjectReference)taskMoRef)).onSuccess(unused -> LOGGER.info("Successfully updated test network mappings for recovery plan '{}' with moRef '{}'.", (Object)ieRecoveryPlan.getName(), (Object)planMoRef)).onError(error -> {
            LOGGER.warn("Unable to update test network mappings for recovery plan '{}' with moRef '{}'.", new Object[]{ieRecoveryPlan.getName(), planMoRef, error});
            ImpexImportSrmContext.get().addError(ImpexL10N.localize("plan.updateTestNetworkMappings", ieRecoveryPlan.getName()), (Exception)error);
        }).thenApply(unused -> null);
    }

    private RecoveryPlanSpec buildUpdateSpec(IeRecoveryPlan ieRp, ManagedObjectReference planMoRef) {
        RecoveryPlan.SiteSettings localSettings;
        Object[] mappingsToAdd = RecoveryTestNetworkMappingConverter.toVmodl(ieRp.getNetworks(), this._inventory);
        RecoveryPlanSpec.SiteSpec siteSpec = new RecoveryPlanSpec.SiteSpec();
        if (ArrayUtils.isNotEmpty((Object[])mappingsToAdd)) {
            siteSpec.mappingsToAdd = mappingsToAdd;
        }
        if ((localSettings = (RecoveryPlan.SiteSettings)this._basicRpsPcResult.tryGetProperty(planMoRef, "localSettings", error -> {
            LOGGER.warn("Unable to retrieve test network mappings for recovery plan '{}' with moRef '{}'.", new Object[]{ieRp.getName(), planMoRef, error});
            return null;
        })) != null && ArrayUtils.isNotEmpty((Object[])localSettings.testNetworkMappings)) {
            siteSpec.mappingsToRemove = (ManagedObjectReference[])Arrays.stream(localSettings.testNetworkMappings).map(InventoryMapperBase.TestNetworkMapping::getKey).toArray(ManagedObjectReference[]::new);
        }
        RecoveryPlanSpec result = new RecoveryPlanSpec();
        result.name = ieRp.getName();
        result.description = ieRp.getDescription();
        result.localSettings = siteSpec;
        return result;
    }
}

