/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.srm.client.impex.importers.inventory.SrmInventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexStageExecutor;
import com.vmware.srm.client.impex.tool.XmlImporterHelper;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.reactive.Promise;
import org.apache.commons.lang.Validate;

public class SrmImpexStages {

    public static class ImportAdvancedSettings
    extends ImpexStageExecutor.ImpexStage {
        public ImportAdvancedSettings(ImpexStageExecutor.StageParams stageParams) {
            super(stageParams);
        }

        @Override
        public Promise<ImpexStageExecutor.StageParams> process(ImpexStageExecutor.StageParams stageParams) {
            return XmlImporterHelper.importAdvancedSettings().thenApply(unused -> stageParams);
        }

        @Override
        public ImpexStageExecutor.ImpexStage getNext(ImpexStageExecutor.StageParams stageParams) {
            return null;
        }
    }

    public static class ImportVmSettings
    extends ImpexStageExecutor.ImpexStage {
        public ImportVmSettings(ImpexStageExecutor.StageParams stageParams) {
            super(stageParams);
        }

        @Override
        public Promise<ImpexStageExecutor.StageParams> process(ImpexStageExecutor.StageParams stageParams) {
            Validate.notNull((Object)stageParams.inventory, (String)"StageParams.inventory");
            return XmlImporterHelper.createVmSettings(stageParams.inventory.getVmKeysLookup()).thenApply(unused -> stageParams);
        }

        @Override
        public ImpexStageExecutor.ImpexStage getNext(ImpexStageExecutor.StageParams stageParams) {
            return new ImportAdvancedSettings(stageParams);
        }
    }

    public static class ImportPlans
    extends ImpexStageExecutor.ImpexStage {
        public ImportPlans(ImpexStageExecutor.StageParams stageParams) {
            super(stageParams);
        }

        @Override
        public Promise<ImpexStageExecutor.StageParams> process(ImpexStageExecutor.StageParams stageParams) {
            return XmlImporterHelper.importRecoveryPlans(stageParams.inventory, stageParams.groupsLookup).thenApply(unused -> stageParams);
        }

        @Override
        public ImpexStageExecutor.ImpexStage getNext(ImpexStageExecutor.StageParams stageParams) {
            return new ImportVmSettings(stageParams);
        }
    }

    public static class ImportGroups
    extends ImpexStageExecutor.ImpexStage {
        public ImportGroups(ImpexStageExecutor.StageParams stageParams) {
            super(stageParams);
        }

        @Override
        public Promise<ImpexStageExecutor.StageParams> process(ImpexStageExecutor.StageParams stageParams) {
            return XmlImporterHelper.importProtectionGroups(stageParams.inventory, stageParams.localProfiles, stageParams.remoteProfiles, stageParams.localDomainInfos, stageParams.remoteDomainInfos).thenApply(stageParams::setGroupsLookup);
        }

        @Override
        public ImpexStageExecutor.ImpexStage getNext(ImpexStageExecutor.StageParams stageParams) {
            return new ImportPlans(stageParams);
        }
    }

    public static class ImportPlaceholders
    extends ImpexStageExecutor.ImpexStage {
        public ImportPlaceholders(ImpexStageExecutor.StageParams stageParams) {
            super(stageParams);
        }

        @Override
        public Promise<ImpexStageExecutor.StageParams> process(ImpexStageExecutor.StageParams stageParams) {
            return XmlImporterHelper.importPlaceholders(stageParams.inventory).thenApply(unused -> stageParams);
        }

        @Override
        public ImpexStageExecutor.ImpexStage getNext(ImpexStageExecutor.StageParams stageParams) {
            return new ImportGroups(stageParams);
        }
    }

    public static class ImportMappings
    extends ImpexStageExecutor.ImpexStage {
        public ImportMappings(ImpexStageExecutor.StageParams stageParams) {
            super(stageParams);
        }

        @Override
        public Promise<ImpexStageExecutor.StageParams> process(ImpexStageExecutor.StageParams stageParams) {
            return XmlImporterHelper.importMappings(stageParams.inventory, stageParams.localProfiles, stageParams.remoteProfiles).thenApply(unused -> stageParams);
        }

        @Override
        public ImpexStageExecutor.ImpexStage getNext(ImpexStageExecutor.StageParams stageParams) {
            return new ImportPlaceholders(stageParams);
        }
    }

    public static class CollectAllFaultDomains
    extends ImpexStageExecutor.ImpexStage {
        public CollectAllFaultDomains(ImpexStageExecutor.StageParams stageParams) {
            super(stageParams);
        }

        @Override
        public Promise<ImpexStageExecutor.StageParams> process(ImpexStageExecutor.StageParams stageParams) {
            return XmlImporterHelper.getFaultDomains(true).thenCombine(XmlImporterHelper.getFaultDomains(false), stageParams::setFaultDomains);
        }

        @Override
        public ImpexStageExecutor.ImpexStage getNext(ImpexStageExecutor.StageParams stageParams) {
            return new ImportMappings(stageParams);
        }
    }

    public static class CollectAllProfiles
    extends ImpexStageExecutor.ImpexStage {
        public CollectAllProfiles(ImpexStageExecutor.StageParams stageParams) {
            super(stageParams);
        }

        @Override
        public Promise<ImpexStageExecutor.StageParams> process(ImpexStageExecutor.StageParams stageParams) {
            return XmlImporterHelper.getProfiles(IContextUtil.getSrmServer(true).vc().spbmService(), IContextUtil.getSrmServer(true).guid()).thenCombine(XmlImporterHelper.getProfiles(IContextUtil.getSrmServer(false).vc().spbmService(), IContextUtil.getSrmServer(false).guid()), stageParams::setProfiles);
        }

        @Override
        public ImpexStageExecutor.ImpexStage getNext(ImpexStageExecutor.StageParams stageParams) {
            return new CollectAllFaultDomains(stageParams);
        }
    }

    public static class CollectServersData
    extends ImpexStageExecutor.ImpexStage {
        public CollectServersData(ImpexStageExecutor.StageParams stageParams) {
            super(stageParams);
        }

        @Override
        protected Promise<ImpexStageExecutor.StageParams> process(ImpexStageExecutor.StageParams stageParams) {
            SrmInventoryExtractor inventoryExtractor = new SrmInventoryExtractor();
            return inventoryExtractor.traverse().thenApply(stageParams::setInventory);
        }

        @Override
        public ImpexStageExecutor.ImpexStage getNext(ImpexStageExecutor.StageParams stageParams) {
            return new CollectAllProfiles(stageParams);
        }
    }
}

