/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.vim.binding.dr.ServiceInstanceContent;
import org.apache.commons.lang.Validate;

public class SrmServersDataWrapper {
    private final SrmServersView _view;
    private final ServiceInstanceContent _localContent;
    private final ServiceInstanceContent _remoteContent;
    private final SrmPairSetup _localPair;
    private final SrmPairSetup _remotePair;

    public SrmServersDataWrapper(SrmServersView view, SrmPairSetup localPair, SrmPairSetup remotePair, ServiceInstanceContent localContent, ServiceInstanceContent remoteContent) {
        Validate.notNull((Object)view, (String)"View");
        Validate.notNull((Object)localPair, (String)"Local pair setup");
        Validate.notNull((Object)remotePair, (String)"Remote pair setup");
        Validate.notNull((Object)localContent, (String)"Local content");
        Validate.notNull((Object)remoteContent, (String)"Remote content");
        this._view = view;
        this._localPair = localPair;
        this._remotePair = remotePair;
        this._localContent = localContent;
        this._remoteContent = remoteContent;
    }

    public SrmServer getLocalServer() {
        return (SrmServer)this._localPair.server();
    }

    public SrmServer getRemoteServer() {
        return (SrmServer)this._remotePair.server();
    }

    public PairSetup<SrmServer> getLocalPair() {
        return this._localPair;
    }

    public PairSetup<SrmServer> getRemotePair() {
        return this._remotePair;
    }

    public SrmServersView getView() {
        return this._view;
    }

    public ServiceInstanceContent getLocalContent() {
        return this._localContent;
    }

    public ServiceInstanceContent getRemoteContent() {
        return this._remoteContent;
    }
}

