/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.internal.ClassLoaderUtil;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.provider.ApiMethodBasedApiInterface;

public abstract class ApiInterfaceSkeleton
extends ApiMethodBasedApiInterface {
    private final TypeConverter converter;

    public ApiInterfaceSkeleton(String iface) {
        this(iface, new TypeConverterImpl());
    }

    public ApiInterfaceSkeleton(String iface, TypeConverter converter) {
        super(iface);
        this.converter = converter;
    }

    protected TypeConverter getTypeConverter() {
        return this.converter;
    }

    protected static final <T> T createImplInstance(Class<? extends T> implClass, String defaultImplClass, Class<T> ifaceClass) {
        try {
            if (implClass == null) {
                ClassLoader cl = ClassLoaderUtil.getServiceClassLoader();
                implClass = cl.loadClass(defaultImplClass).asSubclass(ifaceClass);
            }
            return implClass.newInstance();
        }
        catch (Exception ex) {
            throw new CoreException(MessageFactory.getMessage("vapi.java.invoke.noimpl", ifaceClass.getCanonicalName()), (Throwable)ex);
        }
    }
}

