/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientHeadersProvider;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.SslClientUtil;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;

public class ApacheBioHttpClientBuilder {
    private static final String HTTP_SHEME = "http";
    private static final String HTTPS_SHEME = "https";
    private PoolingHttpClientConnectionManager connManager;
    private RequestConfig defaultRequestConfig;

    public Thread buildConnectionMonitorThread(Logger logger) {
        return new ConnectionMonitor(this.connManager, logger);
    }

    public RequestConfig getDefaultRequestConfig() {
        return this.defaultRequestConfig;
    }

    public CloseableHttpClient buildAndConfigure(final HttpConfiguration httpConfig) {
        this.connManager = this.createConnectionManager(httpConfig);
        this.defaultRequestConfig = ApacheHttpUtil.createDefaultRequestConfig(httpConfig);
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connManager).setUserAgent(ApacheHttpUtil.VAPI_USER_AGENT).setDefaultRequestConfig(this.defaultRequestConfig);
        builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return httpConfig.getKeepAlivePeriod();
            }
        });
        builder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        HttpConfiguration.HeadersProvider headersProvider = httpConfig.getHeadersProvider();
        if (headersProvider != null) {
            builder.addInterceptorFirst((HttpRequestInterceptor)new ApacheClientHeadersProvider(headersProvider));
        }
        return builder.build();
    }

    private PoolingHttpClientConnectionManager createConnectionManager(HttpConfiguration httpConfig) {
        Registry<ConnectionSocketFactory> registry = this.createConnectionSocketFactoryRegistry(httpConfig.getSslConfiguration());
        PoolingHttpClientConnectionManager result = new PoolingHttpClientConnectionManager(registry);
        result.setMaxTotal(httpConfig.getMaxConnections());
        result.setDefaultMaxPerRoute(httpConfig.getMaxConnections());
        return result;
    }

    private Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry(HttpConfiguration.SslConfiguration sslConfig) {
        X509HostnameVerifier hostnameVerifier = SslClientUtil.createHostnameVerifier(sslConfig.isHostnameVerificationDisabled(), SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        return RegistryBuilder.create().register(HTTP_SHEME, (Object)PlainConnectionSocketFactory.INSTANCE).register(HTTPS_SHEME, (Object)new SSLConnectionSocketFactory(SslClientUtil.createSslContext(sslConfig), sslConfig.getEnabledProtocols(), sslConfig.getEnabledCipherSuites(), hostnameVerifier)).build();
    }

    public static final class ConnectionMonitor
    extends Thread {
        private static final String THREAD_NAME = "vAPI-client-connection-monitor-%d";
        private static final AtomicInteger threadCount = new AtomicInteger();
        private final PoolingHttpClientConnectionManager connManager;
        private final Logger logger;

        ConnectionMonitor(PoolingHttpClientConnectionManager connManager, Logger logger) {
            super(String.format(THREAD_NAME, threadCount.getAndIncrement()));
            assert (connManager != null);
            this.connManager = connManager;
            this.logger = logger;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    ConnectionMonitor.sleep(10000L);
                    this.connManager.closeExpiredConnections();
                }
            }
            catch (InterruptedException e) {
                this.logger.debug("Interrupted, no more connection pool cleanups will be performed.");
            }
        }
    }
}

