/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheBioHttpClientBuilder;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientRequestConfigurationMerger;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.common.Util;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import com.vmware.vapi.internal.protocol.common.http.impl.ChunkedTransferEncodingFrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.InputStreamBinaryInput;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClient
implements CorrelatingClient {
    private static Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private final String uri;
    private final CloseableHttpClient httpClient;
    private final ApacheClientRequestConfigurationMerger configMerger;
    private Thread connectionMonitor;
    private final HttpConfiguration.Protocol protocol;

    public HttpClient(String uri) {
        this(uri, new HttpConfiguration.Builder().getConfig());
    }

    public HttpClient(String uri, HttpConfiguration httpConfig) {
        Validate.notNull(uri);
        Validate.notNull(httpConfig);
        this.uri = uri;
        this.protocol = httpConfig.getProtocol();
        this.httpClient = this.createDefaultHttpClient(httpConfig);
        RequestConfig defaultConfig = ApacheHttpUtil.createDefaultRequestConfig(httpConfig);
        this.configMerger = new ApacheClientRequestConfigurationMerger(defaultConfig);
    }

    public HttpClient(String uri, CloseableHttpClient httpClient) {
        Validate.notNull(uri);
        Validate.notNull(httpClient);
        this.uri = uri;
        this.httpClient = httpClient;
        this.protocol = HttpConfiguration.Protocol.VAPI_JSON_RPC_1_0;
        this.configMerger = new ApacheClientRequestConfigurationMerger(null);
    }

    private CloseableHttpClient createDefaultHttpClient(HttpConfiguration httpConfig) {
        assert (httpConfig != null);
        try {
            new URL(this.uri);
        }
        catch (MalformedURLException ex) {
            logger.error("Exception while trying to parse URL", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        ApacheBioHttpClientBuilder httpClientBuilder = new ApacheBioHttpClientBuilder();
        CloseableHttpClient result = httpClientBuilder.buildAndConfigure(httpConfig);
        this.connectionMonitor = httpClientBuilder.buildConnectionMonitorThread(logger);
        this.connectionMonitor.start();
        return result;
    }

    private HttpResponse invoke(InputStream request, int requestLength, ExecutionContext executionContext, AbortHandle abortHandle, CorrelatingClient.ResponseCallback cb, String serviceId, String operationId) throws IOException {
        String requestContentType = "application/json";
        HttpPost post = new HttpPost(this.uri);
        post.setEntity((HttpEntity)new InputStreamEntity(request, (long)requestLength));
        Util.addHeaders(post, requestContentType, this.protocol, serviceId, operationId, executionContext);
        logger.debug("Value of uri is:" + this.uri);
        if (Util.checkRequestAborted(abortHandle, cb)) {
            return null;
        }
        Util.registerAbortListerner(cb, post, abortHandle);
        HttpClientContext context = ApacheHttpUtil.createHttpContext(executionContext, this.configMerger);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post, (HttpContext)context);
        ApacheHttpUtil.validateHttpResponse((HttpResponse)response, requestContentType);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(InputStream request, int requestLength, ExecutionContext executionContext, AbortHandle abortHandle, CorrelatingClient.ResponseCallback cb, String serviceId, String operationId) {
        Validate.notNull(serviceId);
        Validate.notNull(operationId);
        Validate.notNull(request);
        Validate.isTrue(requestLength >= -1);
        Validate.notNull(cb);
        if (Util.checkRequestAborted(abortHandle, cb)) {
            return;
        }
        try {
            HttpResponse httpResponse = this.invoke(request, requestLength, executionContext, abortHandle, cb, serviceId, operationId);
            HttpEntity responseBody = httpResponse.getEntity();
            if (responseBody == null) {
                return;
            }
            String contentType = null;
            if (responseBody.getContentType() != null) {
                contentType = responseBody.getContentType().getValue();
            }
            InputStream inp = responseBody.getContent();
            try {
                this.handleContent(contentType, inp, cb);
            }
            finally {
                IoUtil.silentClose(inp);
            }
        }
        catch (Exception ex) {
            cb.failed(ApacheHttpClientExceptionTranslator.translate(ex, abortHandle, this.uri));
        }
    }

    private void handleContent(String contentType, InputStream content, CorrelatingClient.ResponseCallback cb) throws IOException {
        if (contentType != null && contentType.startsWith("application/vnd.vmware.vapi.framed")) {
            byte[] frame;
            ChunkedTransferEncodingFrameDeserializer frameDeserializer = new ChunkedTransferEncodingFrameDeserializer();
            InputStreamBinaryInput input = new InputStreamBinaryInput(content);
            while ((frame = frameDeserializer.readFrame(input)) != null) {
                cb.received(new ByteArrayInputStream(frame));
            }
        } else {
            byte[] frame = IoUtil.readAll(content);
            cb.received(new ByteArrayInputStream(frame));
        }
    }

    @Override
    public void close() {
        if (this.connectionMonitor != null) {
            this.connectionMonitor.interrupt();
        }
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            logger.warn("Exception while trying to close the HttpClient", (Throwable)e);
        }
    }
}

