/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common;

import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidDataValueException;
import java.util.LinkedList;
import javax.xml.bind.DatatypeConverter;

public class DataValueBuilder {
    public static final String STRUCT_NAME = "struct";
    private final LinkedList<PropertyAppender> appenders = new LinkedList();
    private DataValue result;

    public void start() {
        PropertyAppender appender = new PropertyAppender(){

            @Override
            public void addDataValue(String name, DataValue dv) {
                DataValueBuilder.this.result = dv;
            }
        };
        this.appenders.add(appender);
    }

    public void end() {
        this.pollContext();
    }

    public void addProperty(String name, String value, DataType dataType) {
        this.appendDataValue(name, this.buildPrimitiveValue(value, dataType));
    }

    public void startArray(String propertyName) {
        final ListValue listValue = new ListValue();
        this.appendDataValue(propertyName, listValue);
        this.appenders.add(new PropertyAppender(){

            @Override
            public void addDataValue(String name, DataValue dv) {
                listValue.add(dv);
            }
        });
    }

    public void endArray() {
        this.pollContext();
    }

    public void startStruct(String propertyName) {
        final StructValue structValue = new StructValue(STRUCT_NAME);
        this.appendDataValue(propertyName, structValue);
        this.appenders.add(new PropertyAppender(){

            @Override
            public void addDataValue(String name, DataValue dv) {
                structValue.setField(name, dv);
            }
        });
    }

    public void endStruct() {
        this.pollContext();
    }

    public DataValue getResult() {
        return this.result;
    }

    private void appendDataValue(String name, DataValue dataValue) {
        this.appenders.getLast().addDataValue(name, dataValue);
    }

    private DataValue buildPrimitiveValue(String value, DataType targetType) {
        switch (targetType) {
            case STRING: {
                return new StringValue(value);
            }
            case INTEGER: {
                return new IntegerValue(Long.parseLong(value));
            }
            case DOUBLE: {
                return new DoubleValue(Double.parseDouble(value));
            }
            case BOOLEAN: {
                return DatatypeConverter.parseBoolean((String)value) ? BooleanValue.TRUE : BooleanValue.FALSE;
            }
            case OPTIONAL: {
                return OptionalValue.UNSET;
            }
        }
        throw new JsonInvalidDataValueException("Unsupported data type: " + (Object)((Object)targetType));
    }

    private void pollContext() {
        this.appenders.pollLast();
    }

    private static interface PropertyAppender {
        public void addDataValue(String var1, DataValue var2);
    }
}

