/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.internal.protocol.common.DataValueBuilder;
import com.vmware.vapi.internal.protocol.common.DirectDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidDataValueException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDirectDeserializer
implements DirectDeserializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDirectDeserializer.class);
    private JsonFactory factory;

    public JsonDirectDeserializer(JsonFactory factory) {
        this.factory = factory;
    }

    @Override
    public void deserialize(DataValueBuilder builder, InputStream input) throws IOException {
        try (JsonParser parser = this.factory.createParser(input);){
            parser.nextToken();
            builder.start();
            this.parse(null, parser, builder);
            builder.end();
        }
        catch (JsonParseException ex) {
            LOGGER.error("Error deserializing message.", (Throwable)ex);
            throw ex;
        }
    }

    private void parse(String name, JsonParser parser, DataValueBuilder builder) throws IOException {
        JsonToken currentToken = parser.getCurrentToken();
        if (currentToken == null) {
            return;
        }
        switch (currentToken) {
            case START_ARRAY: {
                builder.startArray(name);
                parser.nextValue();
                this.parseArray(parser, builder);
                builder.endArray();
                break;
            }
            case START_OBJECT: {
                parser.nextToken();
                builder.startStruct(name);
                this.parseStruct(parser, builder);
                builder.endStruct();
                break;
            }
            case VALUE_NULL: {
                builder.addProperty(name, null, DataType.OPTIONAL);
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                builder.addProperty(name, parser.getText(), DataType.BOOLEAN);
                break;
            }
            case VALUE_NUMBER_INT: {
                builder.addProperty(name, parser.getText(), DataType.INTEGER);
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                builder.addProperty(name, parser.getText(), DataType.DOUBLE);
                break;
            }
            case VALUE_STRING: {
                builder.addProperty(name, parser.getText(), DataType.STRING);
                break;
            }
            default: {
                throw new JsonInvalidDataValueException("Unexpected JsonToken type: " + parser.getCurrentToken());
            }
        }
    }

    private void parseStruct(JsonParser parser, DataValueBuilder builder) throws IOException, JsonParseException {
        JsonToken currentToken = parser.getCurrentToken();
        while (currentToken != JsonToken.END_OBJECT && currentToken != null) {
            if (currentToken == JsonToken.FIELD_NAME) {
                String name = parser.getCurrentName();
                parser.nextToken();
                this.parse(name, parser, builder);
            }
            currentToken = parser.nextToken();
        }
    }

    private void parseArray(JsonParser parser, DataValueBuilder builder) throws IOException, JsonParseException {
        JsonToken currentToken = parser.getCurrentToken();
        while (currentToken != JsonToken.END_ARRAY) {
            this.parse(null, parser, builder);
            currentToken = parser.nextToken();
        }
    }
}

