/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.ApiProviderStub;
import com.vmware.vapi.core.ApiProviderStubImpl;
import com.vmware.vapi.internal.protocol.ExecutorApiProvider;
import com.vmware.vapi.internal.protocol.client.msg.json.JsonApiProvider;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpAsyncClientTransport;
import com.vmware.vapi.internal.protocol.client.rpc.http.HttpClient;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.ClientConfiguration;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vapi.protocol.ProtocolConnectionFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;

public class JsonProtocolConnectionFactory
implements ProtocolConnectionFactory {
    private static int DEFAULT_HTTPS_PORT = 443;
    private static int DEFAULT_HTTP_PORT = 80;

    @Override
    public ProtocolConnection getConnection(String type, String args, KeyStore trustStore) {
        if (type.equals(Protocol.http.toString())) {
            HttpConfiguration.SslConfiguration sslConfig = new HttpConfiguration.SslConfiguration.Builder(trustStore).getConfig();
            return this.getHttpConnection(args, null, new HttpConfiguration.Builder().setSslConfiguration(sslConfig).getConfig());
        }
        return null;
    }

    @Override
    public ProtocolConnection getHttpConnection(String uri, ClientConfiguration clientConfig, HttpConfiguration httpConfig) {
        CorrelatingClient transport = this.createCorrelatingClient(uri, clientConfig, httpConfig);
        ApiProvider provider = new JsonApiProvider(transport, clientConfig);
        if (clientConfig != null && clientConfig.getExecutor() != null) {
            provider = new ExecutorApiProvider(provider, clientConfig.getExecutor());
        }
        return new ProtocolConnectionImpl(transport, provider);
    }

    @Override
    public ProtocolConnection getInsecureConnection(String type, String args) {
        if (type.equals(Protocol.http.toString())) {
            return this.getHttpConnection(args, null, null);
        }
        return null;
    }

    private static String setDefaultHTTPConnectionDetails(String uri) {
        Validate.notNull(uri, "URI is required for creating client");
        try {
            URI connUri = new URI(uri);
            if (-1 != connUri.getPort() || connUri.getAuthority() == null || connUri.getAuthority().contains("_") || connUri.getAuthority().contains(":")) {
                return uri;
            }
            int port = -1;
            if ("https".equalsIgnoreCase(connUri.getScheme())) {
                port = DEFAULT_HTTPS_PORT;
            } else if ("http".equalsIgnoreCase(connUri.getScheme())) {
                port = DEFAULT_HTTP_PORT;
            } else {
                throw new IllegalArgumentException("No port specified and no default port found for schema " + connUri.getScheme());
            }
            return new URI(connUri.getScheme(), connUri.getUserInfo(), connUri.getHost(), port, connUri.getPath(), connUri.getQuery(), connUri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse the specified URI " + uri, e);
        }
    }

    private CorrelatingClient createCorrelatingClient(String uri, ClientConfiguration clientConfig, HttpConfiguration httpConfig) {
        if (httpConfig == null) {
            httpConfig = new HttpConfiguration.Builder().getConfig();
        }
        uri = JsonProtocolConnectionFactory.setDefaultHTTPConnectionDetails(uri);
        return this.createHttpTransport(uri, clientConfig, httpConfig);
    }

    protected CorrelatingClient createHttpTransport(String uri, ClientConfiguration clientConfig, HttpConfiguration httpConfig) {
        switch (httpConfig.getLibraryType()) {
            case APACHE_HTTP_CLIENT: {
                return new HttpClient(uri, httpConfig);
            }
            case APACHE_HTTP_ASYNC_CLIENT: {
                return new ApacheHttpAsyncClientTransport(uri, httpConfig, clientConfig != null ? clientConfig.getExecutor() : null);
            }
        }
        throw new IllegalArgumentException("Unsupported library type " + (Object)((Object)httpConfig.getLibraryType()));
    }

    private static final class ProtocolConnectionImpl
    implements ProtocolConnection {
        private final CorrelatingClient transport;
        private final ApiProvider provider;

        private ProtocolConnectionImpl(CorrelatingClient transport, ApiProvider provider) {
            Validate.notNull(transport);
            Validate.notNull(provider);
            this.transport = transport;
            this.provider = provider;
        }

        @Override
        public void disconnect() {
            this.transport.close();
        }

        @Override
        public ApiProvider getApiProvider() {
            return this.provider;
        }

        @Override
        public ApiProviderStub getApiProviderStub() {
            return new ApiProviderStubImpl(this.getApiProvider());
        }
    }

    public static enum Protocol {
        http;

    }
}

