/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.init;

import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ContextApplierImpl;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.dr.ui.tools.utilities.ExecuteOnceOpWrapper;
import com.vmware.dr.ui.tools.utilities.OperationWaiter;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    public static final String CONFIG_FILE_NAME = "h5dr.properties";
    public static final String APP_HOST = "appHost";
    public static final String APP_PORT = "appPort";
    public static final String LSPP_HOST = "lsppHost";
    public static final String LSPP_PORT = "lsppPort";
    public static final String LSPP_THUMBPRINT = "lsppThumbprint";
    public static final String KEY_STORE_NAME = "keyStoreName";
    public static final String KEY_STORE_PASS = "keyStorePass";
    public static final String CERT_ALIAS = "certAlias";
    public static final String RESPONSE_TIMEOUT = "responseTimeout";
    public static final String CONNECT_TIMEOUT = "connectTimeout";
    public static final String LOGS_UI_REQUEST_TIMEOUT = "logsConnectionTimeout";
    public static final String IMPEX_EXPORT_REQUEST_TIMEOUT = "exportSrmConfigTimeout";
    public static final String IMPEX_EXPORT_DELETION_DELAY = "exportSrmConfigDeletionDelay";
    public static final String IMPEX_IMPORT_RETRIES_COUNT = "importSrmConfigRetriesCount";
    public static final String IMPEX_IMPORT_RETRIES_DELAY = "importSrmConfigRetriesDelay";
    public static final String IMPEX_ALLOW_OVERRIDE_PROTECTION_SETTINGS = "allowOverrideProtectionSettings";
    public static final String MAX_CONNECTIONS = "maxConnections";
    public static final String MAX_CONNECTIONS_PER_ROUTE = "maxConnectionsPerRoute";
    public static final String SOCKET_TIMEOUT = "socketTimeout";
    public static final String MAX_REQUEST_SIZE = "maxRequestSize";
    public static final String MAX_CONFIG_REPLICATIONS = "maxConfigReplications";
    public static final String CLOUD_DOMAINS = "cloudDomains";
    public static final String ROBO_ENABLED = "roboEnabled";
    public static final String PHONEHOME_ENABLED = "phonehomeEnabled";
    public static final String PHONEHOME_DEV_ENV = "phonehomeDevEnv";
    public static final String SERVER_GUID = "serverGuid";
    public static final String SEGMENT_ENABLED = "segmentEnabled";
    public static final String SEGMENT_APP_URL = "segmentAppURL";
    public static final String INTERCOM_HASH_KEY = "intercomHashKey";
    public static final String INTERCOM_ENABLED = "intercomEnabled";
    private static final String OAUTH2_CLIENT_ID = "oauth2ClientId";
    private static final String OAUTH2_CLIENT_SECRET = "oauth2ClientSecret";
    private static final String VIDM_ENABLED = "vidmEnabled";
    private static final String HTTP_PROXY = "httpProxy";
    public static final String LOGGER_MANAGER_ENABLED = "loggerManagerEnabled";
    public static final String LOGGER_MANAGER_PORT = "loggerManagerPort";
    public static final String SRM_VAMI_PORT = "srmVamiPort";
    public static final String HMS_SERVICE_TYPE = "hmsServiceType";
    public static final String HMS_EXTENSION_KEY = "hmsExtensionKey";
    public static final String TRUST_STORE_NAME = "drTrustStoreName";
    public static final String TRUST_STORE_PASS = "drTrustStorePass";
    public static final String SESSION_TIMEOUT = "sessionTimeout";
    public static final String ABR_VMOTION_ENABLED = "abrMigrationSupported";
    public static final String APP_BASE_PATH = "/dr";
    public static final Integer DEFAULT_APP_PORT = 443;
    public static final Integer DEFAULT_LSPP_PORT = 443;
    public static final Integer DEFAULT_MAX_REQUEST_SIZE = 0x2000000;
    public static final Integer DEFAULT_MAX_CONFIG_REPLICATIONS = 20;
    public static final Integer DEFAULT_MAX_CONNECTIONS = 32;
    public static final Integer DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 16;
    public static final Long DEFAULT_CONNECT_TIMEOUT = 30000L;
    public static final Long DEFAULT_SOCKET_TIMEOUT = 30000L;
    public static final Long DEFAULT_RESPONSE_TIMEOUT = 60000L;
    public static final Long DEFAULT_LOGS_UI_REQUEST_TIMEOUT = 0x6DDD00L;
    public static final Long DEFAULT_IMPEX_EXPORT_REQUEST_TIMEOUT = 0x6DDD00L;
    public static final Long DEFAULT_IMPEX_EXPORT_DELETION_DELAY = 600000L;
    public static final Integer DEFAULT_IMPEX_IMPORT_RETRIES_COUNT = 5;
    public static final Integer DEFAULT_IMPEX_IMPORT_RETRIES_DELAY = 10000;
    public static final Boolean DEFAULT_IMPEX_ALLOW_OVERRIDE_PROTECTION_SETTINGS = false;
    public static final Boolean DEFAULT_LOGGER_MANAGER_ENABLED = false;
    public static final Integer DEFAULT_LOGGER_MANAGER_PORT = 8529;
    public static final Integer DEFAULT_SRM_VAMI_PORT = 5480;
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    private static final String DEFAULT_CLOUD_DOMAINS = ".vmc.vmware.com, .vmwarevmc.com, .vmwarevmcgov.com";
    private static final Boolean DEFAULT_ROBO_ENABLED = true;
    private static final Boolean DEFAULT_PHONEHOME_ENABLED = true;
    private static final Boolean DEFAULT_PHONEHOME_DEV_ENV = false;
    private static final String DEFAULT_SERVER_GUID = "00000000-0000-0000-0000-000000000000";
    private static final Boolean DEFAULT_SEGMENT_ENABLED = false;
    private static final String DEFAULT_SEGMENT_APP_URL = "https://cdn.segment.com/analytics.js/v1/jqskNns0LxIU2guZHwJFjVQCY9Rh1vCp/analytics.min.js";
    private static final Boolean DEFAULT_INTERCOM_ENABLED = false;
    private static final String DEFAULT_INTERCOM_HASH_KEY = "";
    private static final String DEFAULT_HMS_SERVICE_TYPE = "com.vmware.vr.vrms";
    private static final String DEFAULT_HMS_EXTENSION_KEY = "com.vmware.vcHms";
    private static final String DEFAULT_OAUTH2_CLIENT_ID = "";
    private static final String DEFAULT_OAUTH2_CLIENT_SECRET = "";
    private static final Boolean DEFAULT_VIDM_ENABLED = false;
    private static final Integer DEFAULT_SESSION_TIMEOUT = 7200;
    private static final Boolean DEFAULT_ABR_VMOTION_ENABLED = false;
    private static final Properties DEFAULTS = new Properties();
    private static final Set<String> NON_DEFAULTS = new HashSet<String>(Arrays.asList("appHost", "lsppHost", "lsppThumbprint", "keyStoreName", "keyStorePass", "certAlias", "drTrustStoreName", "drTrustStorePass"));
    private static final String PROTOCOL = "https";
    private static final String PROP_VALUE_FORMAT = "{}: {}";
    private static final ThreadLocal<KeyStore> TRUST_STORE;
    private static final Config CONFIG;
    private final ExecuteOnceOpWrapper<Void> _loadOp = new ExecuteOnceOpWrapper(() -> {
        this.load();
        return null;
    });
    private volatile URI _appUrl;
    private volatile String _appHost;
    private volatile URI _lsppUrl;
    private volatile String _lsppThumbprint;
    private volatile String _keyStoreName;
    private volatile String _keyStorePass;
    private volatile String _certAlias;
    private volatile String _serverGuid;
    private volatile long _connectTimeout;
    private volatile long _logsUIRequestTimeout;
    private volatile int _maxConnections;
    private volatile int _maxConnectionsPerRoute;
    private volatile long _socketTimeout;
    private volatile long _responseTimeout;
    private volatile long _impexExportRequestTimeout;
    private volatile long _impexExportDeletionDelay;
    private volatile int _impexImportRetriesCount;
    private volatile int _impexImportRetriesDelay;
    private volatile boolean _allowOverrideProtectionSettings;
    private volatile int _maxRequestSize;
    private volatile int _maxConfigReplications;
    private volatile boolean _roboEnabled;
    private volatile boolean _phonehomeEnabled;
    private volatile boolean _phonehomeDevEnv;
    private volatile boolean _segmentEnabled;
    private volatile String _segmentAppUrl;
    private volatile boolean _intercomEnabled;
    private volatile String _intercomHashKey;
    private volatile String _oauth2ClientId;
    private volatile String _oauth2ClientSecret;
    private volatile Boolean _vidmEnabled;
    private volatile URI _httpProxyUrl;
    private volatile boolean _loggerManagerEnabled;
    private volatile int _loggerManagerPort;
    private volatile int _srmVamiPort;
    private volatile String _hmsServiceType;
    private volatile String _hmsExtensionKey;
    private volatile KeyStore _trustStore;
    private volatile int _sessionTimeout;
    private volatile boolean _abrVmotionEnabled;
    private final Set<String> _cloudDomains = new HashSet<String>();

    public static Set<String> getNonDefaultProperties() {
        return Collections.unmodifiableSet(NON_DEFAULTS);
    }

    public static Properties mergeWithDefaults(Properties props) {
        HashMap defaults = new HashMap();
        DEFAULTS.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> defaults.put((String)key, (String)value)));
        Properties result = new Properties();
        result.putAll((Map<?, ?>)defaults);
        result.putAll((Map<?, ?>)props);
        return result;
    }

    public static URI createLsppUrl(String lsppHost, int lsppPort) throws URISyntaxException {
        Validate.notEmpty((String)lsppHost, (String)LSPP_HOST);
        return new URI(PROTOCOL, null, lsppHost, lsppPort == -1 ? 443 : lsppPort, "/lookupservice/sdk", null, null).parseServerAuthority();
    }

    public static URI createAppUrl(String appHost, int appPort) throws URISyntaxException {
        return Config.getAppBaseUrl(PROTOCOL, appHost, appPort, APP_BASE_PATH);
    }

    public static URI getAppBaseUrl(String scheme, String host, int port, String contextPath) throws URISyntaxException {
        Validate.notEmpty((String)host, (String)APP_HOST);
        int n = port = PROTOCOL.equals(scheme) && port == 443 ? -1 : port;
        if (StringUtils.isNotEmpty((String)contextPath) && !contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        URI appBaseUrl = new URI(scheme, null, host, port, contextPath, null, null);
        return appBaseUrl.parseServerAuthority();
    }

    public static <T> T executeWithTrustStore(Callable<T> exec, KeyStore trustStore) throws Exception {
        return (T)ThreadContext.extendContext(exec, (ContextApplier)new ContextApplierImpl(TRUST_STORE, (Object)trustStore));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException, URISyntaxException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        String trustStoreName;
        String[] cloudDomains;
        ClassLoader loader = Config.class.getClassLoader();
        InputStream input = loader.getResourceAsStream(CONFIG_FILE_NAME);
        if (input == null) {
            throw new NotInitializedException(CONFIG_FILE_NAME);
        }
        Properties prop = new Properties();
        try (InputStream io = input;){
            prop.load(io);
        }
        this.logProperties(prop);
        prop = Config.mergeWithDefaults(prop);
        this._appHost = prop.getProperty(APP_HOST);
        Validate.notEmpty((String)this._appHost, (String)APP_HOST);
        int appPort = this.getIntValue(prop, APP_PORT);
        this._appUrl = Config.createAppUrl(this._appHost, appPort);
        String lsppHost = prop.getProperty(LSPP_HOST);
        Validate.notEmpty((String)lsppHost, (String)LSPP_HOST);
        int lsppPort = this.getIntValue(prop, LSPP_PORT);
        this._lsppUrl = Config.createLsppUrl(lsppHost, lsppPort);
        String lsppThumbprint = prop.getProperty(LSPP_THUMBPRINT);
        Validate.notEmpty((String)lsppThumbprint, (String)LSPP_THUMBPRINT);
        this._lsppThumbprint = lsppThumbprint;
        String name = prop.getProperty(KEY_STORE_NAME);
        Validate.notEmpty((String)name, (String)"keyStore name");
        this._keyStoreName = name;
        String pass = prop.getProperty(KEY_STORE_PASS);
        Validate.notEmpty((String)pass, (String)"keyStore password");
        this._keyStorePass = pass;
        String alias = prop.getProperty(CERT_ALIAS);
        Validate.notEmpty((String)alias, (String)"certificate alias");
        this._certAlias = alias;
        this._connectTimeout = this.getLongValue(prop, CONNECT_TIMEOUT);
        this._logsUIRequestTimeout = this.getLongValue(prop, LOGS_UI_REQUEST_TIMEOUT);
        this._maxConnections = this.getIntValue(prop, MAX_CONNECTIONS);
        this._maxConnectionsPerRoute = this.getIntValue(prop, MAX_CONNECTIONS_PER_ROUTE);
        this._socketTimeout = this.getLongValue(prop, SOCKET_TIMEOUT);
        this._responseTimeout = this.getLongValue(prop, RESPONSE_TIMEOUT);
        this._impexExportRequestTimeout = this.getLongValue(prop, IMPEX_EXPORT_REQUEST_TIMEOUT);
        this._impexExportDeletionDelay = this.getImpexExportDeletionDelay(prop);
        this._impexImportRetriesCount = this.getIntValue(prop, IMPEX_IMPORT_RETRIES_COUNT);
        this._impexImportRetriesDelay = this.getIntValue(prop, IMPEX_IMPORT_RETRIES_DELAY);
        this._allowOverrideProtectionSettings = this.getBoolValue(prop, IMPEX_ALLOW_OVERRIDE_PROTECTION_SETTINGS);
        this._maxRequestSize = this.getIntValue(prop, MAX_REQUEST_SIZE);
        this._maxConfigReplications = this.getIntValue(prop, MAX_CONFIG_REPLICATIONS);
        this._roboEnabled = this.getBoolValue(prop, ROBO_ENABLED);
        this._phonehomeEnabled = this.getBoolValue(prop, PHONEHOME_ENABLED);
        this._phonehomeDevEnv = this.getBoolValue(prop, PHONEHOME_DEV_ENV);
        this._serverGuid = prop.getProperty(SERVER_GUID);
        this._segmentEnabled = this.getBoolValue(prop, SEGMENT_ENABLED);
        this._segmentAppUrl = prop.getProperty(SEGMENT_APP_URL);
        this._intercomEnabled = this.getBoolValue(prop, INTERCOM_ENABLED);
        this._intercomHashKey = prop.getProperty(INTERCOM_HASH_KEY);
        this._loggerManagerEnabled = this.getBoolValue(prop, LOGGER_MANAGER_ENABLED);
        this._loggerManagerPort = this.getIntValue(prop, LOGGER_MANAGER_PORT);
        this._srmVamiPort = this.getIntValue(prop, SRM_VAMI_PORT);
        this._hmsServiceType = this.getPropertyNotEmpty(prop, HMS_SERVICE_TYPE);
        this._hmsExtensionKey = this.getPropertyNotEmpty(prop, HMS_EXTENSION_KEY);
        String cloudDomainsVals = prop.getProperty(CLOUD_DOMAINS);
        for (String cd : cloudDomains = cloudDomainsVals.split(",")) {
            String domain = cd.trim().toLowerCase();
            this.validateDomain(domain);
            this._cloudDomains.add(domain);
        }
        this._oauth2ClientId = prop.getProperty(OAUTH2_CLIENT_ID);
        this._oauth2ClientSecret = prop.getProperty(OAUTH2_CLIENT_SECRET);
        this._vidmEnabled = this.getBoolValue(prop, VIDM_ENABLED);
        String proxyAddr = prop.getProperty(HTTP_PROXY);
        if (StringUtils.isNotEmpty((String)proxyAddr)) {
            try {
                this._httpProxyUrl = new URI(proxyAddr).parseServerAuthority();
            }
            catch (URISyntaxException exc) {
                LOGGER.error("Failed to parse proxy url", (Throwable)exc);
            }
        }
        if (StringUtils.isNotEmpty((String)(trustStoreName = prop.getProperty(TRUST_STORE_NAME)))) {
            String trustStoreCreds = prop.getProperty(TRUST_STORE_PASS, "");
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream storeStream = loader.getResourceAsStream(trustStoreName);
            if (storeStream == null) {
                throw new RuntimeException("Trust store '" + trustStoreName + "' is not accessible.");
            }
            try {
                trustStore.load(storeStream, trustStoreCreds.toCharArray());
            }
            finally {
                storeStream.close();
            }
            this._trustStore = trustStore;
        }
        this._sessionTimeout = this.getIntValue(prop, SESSION_TIMEOUT);
        this._abrVmotionEnabled = this.getBoolValue(prop, ABR_VMOTION_ENABLED);
    }

    private void logProperties(Properties props) {
        LOGGER.info("VMware Site Recovery Client current configuration:");
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.logProperty(key, value)));
    }

    private void logProperty(Object key, Object value) {
        if (key == null) {
            return;
        }
        String valueToPrint = key.toString().equalsIgnoreCase(KEY_STORE_PASS) || key.toString().equalsIgnoreCase(OAUTH2_CLIENT_SECRET) ? "**********" : value.toString();
        LOGGER.info(PROP_VALUE_FORMAT, (Object)key.toString(), (Object)valueToPrint);
    }

    public static Config get() {
        return CONFIG;
    }

    private Config() {
    }

    public final URI getAppUrl() {
        this.init();
        return this._appUrl;
    }

    public final URI getLsppUrl() {
        this.init();
        return this._lsppUrl;
    }

    public final String getLsppThumbprint() {
        this.init();
        return this._lsppThumbprint;
    }

    public final String getKeyStoreName() {
        this.init();
        return this._keyStoreName;
    }

    public final String getKeyStorePass() {
        this.init();
        return this._keyStorePass;
    }

    public final String getCertAlias() {
        this.init();
        return this._certAlias;
    }

    public final long getConnectTimeout() {
        this.init();
        return this._connectTimeout;
    }

    public final long getLogsUIRequestTimeout() {
        this.init();
        return this._logsUIRequestTimeout;
    }

    public final int getMaxConnections() {
        this.init();
        return this._maxConnections;
    }

    public final int getMaxConnectionsPerRoute() {
        this.init();
        return this._maxConnectionsPerRoute;
    }

    public final long getSocketTimeout() {
        this.init();
        return this._socketTimeout;
    }

    public final long getResponseTimeout() {
        this.init();
        return this._responseTimeout;
    }

    public final long getImpexExportRequestTimeout() {
        this.init();
        return this._impexExportRequestTimeout;
    }

    public final long getImpexExportDeletionDelay() {
        this.init();
        return this._impexExportDeletionDelay;
    }

    public int getImpexImportRetriesCount() {
        this.init();
        return this._impexImportRetriesCount;
    }

    public int getImpexImportRetriesDelay() {
        this.init();
        return this._impexImportRetriesDelay;
    }

    public boolean getAllowOverrideProtectionSettings() {
        this.init();
        return this._allowOverrideProtectionSettings;
    }

    public final int getMaxRequestSize() {
        this.init();
        return this._maxRequestSize;
    }

    public final int getMaxConfigReplications() {
        this.init();
        return this._maxConfigReplications;
    }

    public final boolean getRoboEnabled() {
        this.init();
        return this._roboEnabled;
    }

    public final boolean getPhonehomeEnabled() {
        this.init();
        return this._phonehomeEnabled;
    }

    public final boolean getPhonehomeDevEnv() {
        this.init();
        return this._phonehomeDevEnv;
    }

    public String getServerGuid() {
        this.init();
        return this._serverGuid;
    }

    public final boolean getSegmentEnabled() {
        this.init();
        return this._segmentEnabled;
    }

    public final String getSegmentAppUrl() {
        this.init();
        return this._segmentAppUrl;
    }

    public final boolean getIntercomEnabled() {
        this.init();
        return this._intercomEnabled;
    }

    public final String getIntercomHashKey() {
        this.init();
        return this._intercomHashKey;
    }

    public final boolean getLoggerManagerEnabled() {
        this.init();
        return this._loggerManagerEnabled;
    }

    public final int getLoggerManagerPort() {
        this.init();
        if (!this.getLoggerManagerEnabled()) {
            throw new IllegalStateException("LoggerManager not enabled.");
        }
        return this._loggerManagerPort;
    }

    public final int getSrmVamiPort() {
        this.init();
        return this._srmVamiPort;
    }

    public String getHmsServiceType() {
        OperationWaiter<Void> initOp = this.ensureLoaded();
        Exception exc = initOp.getError();
        if (exc == null) {
            return this._hmsServiceType;
        }
        if (exc instanceof NotInitializedException) {
            LOGGER.warn("Failed to initialize hmsServiceType. Using default value {}.", (Object)DEFAULT_HMS_SERVICE_TYPE, (Object)exc);
            return DEFAULT_HMS_SERVICE_TYPE;
        }
        throw Exceptions.getRuntimeException((Throwable)exc);
    }

    public String getHmsExtensionKey() {
        OperationWaiter<Void> initOp = this.ensureLoaded();
        Exception exc = initOp.getError();
        if (exc == null) {
            return this._hmsExtensionKey;
        }
        if (exc instanceof NotInitializedException) {
            LOGGER.warn("Failed to initialize hmsExtensionKey. Using default value {}.", (Object)DEFAULT_HMS_EXTENSION_KEY, (Object)exc);
            return DEFAULT_HMS_EXTENSION_KEY;
        }
        throw Exceptions.getRuntimeException((Throwable)exc);
    }

    public KeyStore getTrustStore() {
        OperationWaiter<Void> initOp = this.ensureLoaded();
        Exception exc = initOp.getError();
        if (exc == null) {
            return this._trustStore;
        }
        if (exc instanceof NotInitializedException) {
            LOGGER.warn("Configuration not initialized.", (Throwable)exc);
            return TRUST_STORE.get();
        }
        throw Exceptions.getRuntimeException((Throwable)exc);
    }

    public final Set<String> getCloudDomains() {
        this.init();
        return Collections.unmodifiableSet(this._cloudDomains);
    }

    public final boolean isVMwareCloudDeploy() {
        this.init();
        Set<String> cloudDomains = this.getCloudDomains();
        if (cloudDomains.isEmpty()) {
            return false;
        }
        return cloudDomains.stream().anyMatch(domain -> this._appHost.endsWith((String)domain));
    }

    public final String getOauth2ClientId() {
        this.init();
        return this._oauth2ClientId;
    }

    public final String getOauth2ClientSecret() {
        this.init();
        return this._oauth2ClientSecret;
    }

    public final boolean getVidmEnabled() {
        this.init();
        return this._vidmEnabled;
    }

    public final URI getHttpProxy() {
        this.init();
        return this._httpProxyUrl;
    }

    public final int getSessionTimeout() {
        this.init();
        return this._sessionTimeout;
    }

    public final boolean getAbrVmotionEnabled() {
        this.init();
        return this._abrVmotionEnabled;
    }

    public OperationWaiter<Void> ensureLoaded() {
        return this._loadOp.invoke();
    }

    private void init() {
        this._loadOp.invoke().get();
    }

    private long getLongValue(Properties props, String propName) {
        try {
            return Long.parseLong(props.getProperty(propName));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(propName, e);
        }
    }

    private int getIntValue(Properties props, String propName) {
        try {
            return Integer.parseInt(props.getProperty(propName));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(propName, e);
        }
    }

    private boolean getBoolValue(Properties props, String propName) {
        return Boolean.parseBoolean(props.getProperty(propName));
    }

    private String getPropertyNotEmpty(Properties props, String property) {
        String val = props.getProperty(property);
        Validate.notEmpty((String)val, (String)property);
        return val;
    }

    private long getImpexExportDeletionDelay(Properties prop) {
        int minVal = 60000;
        long inputValue = this.getLongValue(prop, IMPEX_EXPORT_DELETION_DELAY);
        if (inputValue <= (long)minVal) {
            LOGGER.warn("Invalid value for {}: {}. Min: {}. Will use {}.", new Object[]{IMPEX_EXPORT_DELETION_DELAY, inputValue, minVal, DEFAULT_IMPEX_EXPORT_DELETION_DELAY});
            return DEFAULT_IMPEX_EXPORT_DELETION_DELAY;
        }
        return inputValue;
    }

    private void validateDomain(String domain) {
        if (StringUtils.isEmpty((String)domain)) {
            throw new IllegalArgumentException("Invalid domain '" + domain + "'");
        }
        if (domain.charAt(0) != '.') {
            domain = '.' + domain;
        }
        String fqdn = "dr" + domain;
        try {
            new URI(fqdn).parseServerAuthority();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid domain '" + domain + "'");
        }
    }

    static {
        DEFAULTS.setProperty(APP_PORT, DEFAULT_APP_PORT.toString());
        DEFAULTS.setProperty(LSPP_PORT, DEFAULT_LSPP_PORT.toString());
        DEFAULTS.setProperty(RESPONSE_TIMEOUT, DEFAULT_RESPONSE_TIMEOUT.toString());
        DEFAULTS.setProperty(CONNECT_TIMEOUT, DEFAULT_CONNECT_TIMEOUT.toString());
        DEFAULTS.setProperty(LOGS_UI_REQUEST_TIMEOUT, DEFAULT_LOGS_UI_REQUEST_TIMEOUT.toString());
        DEFAULTS.setProperty(MAX_CONNECTIONS, DEFAULT_MAX_CONNECTIONS.toString());
        DEFAULTS.setProperty(MAX_CONNECTIONS_PER_ROUTE, DEFAULT_MAX_CONNECTIONS_PER_ROUTE.toString());
        DEFAULTS.setProperty(SOCKET_TIMEOUT, DEFAULT_SOCKET_TIMEOUT.toString());
        DEFAULTS.setProperty(MAX_REQUEST_SIZE, DEFAULT_MAX_REQUEST_SIZE.toString());
        DEFAULTS.setProperty(IMPEX_EXPORT_REQUEST_TIMEOUT, DEFAULT_IMPEX_EXPORT_REQUEST_TIMEOUT.toString());
        DEFAULTS.setProperty(IMPEX_EXPORT_DELETION_DELAY, DEFAULT_IMPEX_EXPORT_DELETION_DELAY.toString());
        DEFAULTS.setProperty(IMPEX_IMPORT_RETRIES_COUNT, DEFAULT_IMPEX_IMPORT_RETRIES_COUNT.toString());
        DEFAULTS.setProperty(IMPEX_IMPORT_RETRIES_DELAY, DEFAULT_IMPEX_IMPORT_RETRIES_DELAY.toString());
        DEFAULTS.setProperty(IMPEX_ALLOW_OVERRIDE_PROTECTION_SETTINGS, DEFAULT_IMPEX_ALLOW_OVERRIDE_PROTECTION_SETTINGS.toString());
        DEFAULTS.setProperty(MAX_CONFIG_REPLICATIONS, DEFAULT_MAX_CONFIG_REPLICATIONS.toString());
        DEFAULTS.setProperty(CLOUD_DOMAINS, DEFAULT_CLOUD_DOMAINS);
        DEFAULTS.setProperty(ROBO_ENABLED, DEFAULT_ROBO_ENABLED.toString());
        DEFAULTS.setProperty(PHONEHOME_ENABLED, DEFAULT_PHONEHOME_ENABLED.toString());
        DEFAULTS.setProperty(PHONEHOME_DEV_ENV, DEFAULT_PHONEHOME_DEV_ENV.toString());
        DEFAULTS.setProperty(SEGMENT_ENABLED, DEFAULT_SEGMENT_ENABLED.toString());
        DEFAULTS.setProperty(SEGMENT_APP_URL, DEFAULT_SEGMENT_APP_URL);
        DEFAULTS.setProperty(INTERCOM_ENABLED, DEFAULT_INTERCOM_ENABLED.toString());
        DEFAULTS.setProperty(SERVER_GUID, DEFAULT_SERVER_GUID);
        DEFAULTS.setProperty(OAUTH2_CLIENT_ID, "");
        DEFAULTS.setProperty(OAUTH2_CLIENT_SECRET, "");
        DEFAULTS.setProperty(INTERCOM_HASH_KEY, "");
        DEFAULTS.setProperty(LOGGER_MANAGER_ENABLED, DEFAULT_LOGGER_MANAGER_ENABLED.toString());
        DEFAULTS.setProperty(LOGGER_MANAGER_PORT, DEFAULT_LOGGER_MANAGER_PORT.toString());
        DEFAULTS.setProperty(SRM_VAMI_PORT, DEFAULT_SRM_VAMI_PORT.toString());
        DEFAULTS.setProperty(HMS_SERVICE_TYPE, DEFAULT_HMS_SERVICE_TYPE);
        DEFAULTS.setProperty(HMS_EXTENSION_KEY, DEFAULT_HMS_EXTENSION_KEY);
        DEFAULTS.setProperty(VIDM_ENABLED, DEFAULT_VIDM_ENABLED.toString());
        DEFAULTS.setProperty(SESSION_TIMEOUT, DEFAULT_SESSION_TIMEOUT.toString());
        DEFAULTS.setProperty(ABR_VMOTION_ENABLED, DEFAULT_ABR_VMOTION_ENABLED.toString());
        TRUST_STORE = new ThreadLocal();
        CONFIG = new Config();
    }

    public static class NotInitializedException
    extends FileNotFoundException {
        NotInitializedException(String file) {
            super(file);
        }
    }
}

