/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.pbm;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.pbm.SpbmService;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.FixedVersionServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.HttpConfigManagerUtils;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VlsiClientUtils;
import com.vmware.vim.binding.pbm.ServiceInstance;
import com.vmware.vim.binding.pbm.ServiceInstanceContent;
import com.vmware.vim.binding.pbm.version.internal.version11;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.KeyStore;
import org.apache.commons.lang.Validate;

public class SpbmServiceImpl
extends FixedVersionServiceImpl<ServiceInstance, ServiceInstanceContent>
implements SpbmService {
    public static final Class<? extends Annotation> VERSION = version11.class;
    public static final ManagedObjectReference SERVICE_INSTANCE;
    public static final VmodlContextInitializer VMODL_INIT;
    private final String _solutionUser;

    public SpbmServiceImpl(URI server, KeyStore store, TokenProvider tokenProvider, String solutionUser) {
        super(server, HttpConfigManagerUtils.COMMON_MANAGER.getConfiguration(), VMODL_INIT, tokenProvider, SERVICE_INSTANCE, "Storage Policy Server", VERSION);
        Validate.notEmpty((String)solutionUser, (String)"solutionUser");
        this._solutionUser = solutionUser;
        HttpConfigManagerUtils.COMMON_MANAGER.addThumbprints(store);
    }

    @Override
    protected String getServerGuid(ServiceInstanceContent content) {
        return content.getAboutInfo().getInstanceUuid();
    }

    @Override
    protected Promise<ServiceInstanceContent> retrieveContent(ServiceInstance serviceInstance) {
        FuturePromise result = new FuturePromise();
        serviceInstance.retrieveContent((Future)result);
        return result;
    }

    @Override
    protected Promise<Void> login(ServiceInstanceContent content, String locale) {
        Promise logout = this.logout(content).materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return this.getVmomiClient().thenApply(client -> {
                    VlsiClientUtils.clearSessionId(client);
                    return null;
                });
            }
            Exception cause = pr.getError();
            if (cause instanceof SecurityError) {
                return this.getVmomiClient().thenApply(client -> {
                    VlsiClientUtils.clearSessionId(client);
                    return null;
                });
            }
            return Promises.reject((Exception)pr.getError());
        });
        Promise delegateToken = Promises.from(() -> this.getTokenProvider().acquireDelegatedToken(this._solutionUser));
        return logout.thenCompose(unused -> this.createLoginStub(content.getSessionManager())).thenCombineCompose(delegateToken, (sm, delegate) -> {
            FuturePromise result = new FuturePromise();
            sm.loginByToken(delegate.toXml(), (Future)result);
            return result;
        });
    }

    @Override
    protected Promise<Void> logout(ServiceInstanceContent content) {
        return this.createFreeStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.logout((Future)result);
            return result;
        });
    }

    @Override
    protected boolean retryOnError(Exception err) {
        return err instanceof SecurityError || super.retryOnError(err);
    }

    static {
        VmodlContext context = VmodlContext.createContext((String[])new String[0], (boolean)false);
        VMODL_INIT = new VmodlContextInitializer(context, VERSION);
        SERVICE_INSTANCE = ClientUtils.createMoRef("PbmServiceInstance", "ServiceInstance", null);
    }
}

