/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.http.Constants;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class ApacheClientHeadersProvider
implements HttpRequestInterceptor {
    private static final Log LOG = LogFactory.getLog(ApacheClientHeadersProvider.class);
    private HttpConfiguration.HeadersProvider headersProvider;

    public ApacheClientHeadersProvider(HttpConfiguration.HeadersProvider headersProvider) {
        this.headersProvider = headersProvider;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Iterable<HttpConfiguration.Header> headers = this.headersProvider.getHeaders();
        if (headers == null) {
            return;
        }
        for (HttpConfiguration.Header header : headers) {
            String name = header.getName();
            if (Constants.Header.RESERVED_HEADERS.contains(name.toLowerCase())) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("HTTP custom header (%s) won't be sent over the wire. The header name is reserved by the VLSI client.", header));
                continue;
            }
            request.addHeader(name, header.getValue());
        }
    }
}

