/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.CsrfGuard;
import com.vmware.srm.client.infrastructure.authentication.SessionInfo;
import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import com.vmware.srm.client.infrastructure.authentication.data.ServerGuidData;
import com.vmware.srm.client.infrastructure.authentication.data.SiteAuthenticatedData;
import com.vmware.srm.client.infrastructure.requestHandlers.context.DrRequestContext;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.reactive.impl.request.RequestContext;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.sso.SolutionUserConfig;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SubjectNameId;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationUtils.class);

    public static boolean isAuthenticated(HttpServletRequest request) {
        TopologyImpl topology;
        Validate.notNull((Object)request, (String)"request");
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        try {
            topology = SessionWrapper.getTopology(session);
        }
        catch (IllegalStateException exc) {
            return false;
        }
        return topology != null && topology.isAuthenticated();
    }

    public static void invalidateSession(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"request");
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        try {
            session.invalidate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static Promise<TopologyImpl> createTopology(SsoContext context, SamlToken actAsToken, String username, String sessionId) {
        Config appConfig;
        try {
            appConfig = Config.get();
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
        Callable<Promise> call = () -> {
            TopologyImpl impl = new TopologyImpl(appConfig.getLsppUrl(), appConfig.getLsppThumbprint(), SolutionUserConfig.get());
            try {
                return impl.init(context.getSolutionUserToken(), actAsToken).thenCompose(view -> view.getLocalServers().collect()).thenApply(unused -> impl).onError(unused -> impl.destroy());
            }
            catch (Exception exc) {
                impl.destroy();
                return Promises.reject((Exception)exc);
            }
        };
        Callable<Promise> noContext = () -> (Promise)RequestContext.noContext((Callable)call);
        try {
            return SessionInfo.withSessionInfo(noContext, username, sessionId).call();
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
    }

    public static Promise<Void> setupSession(SsoContext ssoContext, AuthenticationStrategy authStrategy, String username, SamlToken token, String sessionIndex, String redirectPath, HttpServletRequest request, HttpServletResponse response) {
        if (request.getSession(false) != null) {
            return Promises.reject((Exception)new IllegalArgumentException("Session already created."));
        }
        String sessionIdAlias = String.valueOf(new SecureRandom().nextLong());
        String sessionUser = username == null ? AuthenticationUtils.getUsername(token) : username;
        return AuthenticationUtils.createTopology(ssoContext, token, sessionUser, sessionIdAlias).thenApply(topology -> {
            HttpSession newSession;
            try {
                newSession = request.getSession(true);
            }
            catch (RuntimeException exc) {
                LOGGER.error("Failed to create new session: ", (Throwable)exc);
                topology.destroy();
                throw exc;
            }
            if (newSession == null) {
                topology.destroy();
                throw new IllegalStateException("Session is null.");
            }
            if (!newSession.isNew()) {
                topology.destroy();
                throw new IllegalStateException("Session already created.");
            }
            LOGGER.info("Session {} started.", (Object)sessionIdAlias);
            SessionWrapper.setSessionIdAlias(newSession, sessionIdAlias);
            CsrfGuard.guardSession(request, response);
            try {
                SessionWrapper.setTopology(newSession, topology);
            }
            catch (IllegalStateException exc) {
                topology.destroy();
                throw exc;
            }
            SessionWrapper.setAuthStrategy(newSession, authStrategy);
            SessionWrapper.setUsername(newSession, sessionUser);
            SessionWrapper.setWsLocale(newSession, request.getLocale());
            if (sessionIndex != null) {
                SessionWrapper.setSessionIndex(newSession, sessionIndex);
                if (!SessionWrapper.addSession(newSession, sessionIndex)) {
                    newSession.invalidate();
                    throw new RuntimeException("Session for given session index already added.");
                }
            }
            SessionWrapper.setInitialRedirectPath(newSession, redirectPath);
            try {
                response.sendRedirect("/dr/authentication/confirm");
            }
            catch (IOException exc) {
                LOGGER.error("Failed to redirect response:", (Throwable)exc);
            }
            return null;
        });
    }

    public static void destroySession(HttpSession session) {
        Validate.notNull((Object)session, (String)"session");
        try {
            session.invalidate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static String getUsername(SamlToken token) {
        Validate.notNull((Object)token, (String)"token");
        PrincipalId pid = token.getSubject();
        if (pid != null) {
            return pid.getName() + '@' + pid.getDomain();
        }
        SubjectNameId sni = token.getSubjectNameId();
        if (sni != null) {
            return sni.getValue();
        }
        return "";
    }

    public static Promise<SiteAuthenticatedData> checkLoginRequired(DrRequestContext<? extends ServersView> context, String remoteVcGuid) {
        ServerGuidData data = new ServerGuidData();
        data.setPairServerGuid(remoteVcGuid);
        return context.dispatch("getSiteAuthenticatedData", data).materialize().thenApply(siteAuthenticatedResult -> {
            if (siteAuthenticatedResult.isSuccessful()) {
                return (SiteAuthenticatedData)siteAuthenticatedResult.getResult();
            }
            return new SiteAuthenticatedData("", false);
        });
    }
}

