/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.oauth2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.http.io.AsyncClientUtils;
import com.vmware.srm.client.infrastructure.http.io.HttpResponseController;
import com.vmware.srm.client.infrastructure.vapi.AsyncCallbackPromise;
import com.vmware.srm.client.infrastructure.vapi.VapiServiceImpl;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.SslTrust;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vcenter.tokenservice.TokenExchange;
import com.vmware.vcenter.tokenservice.TokenExchangeTypes;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpStatus;

public class OAuth2AuthenticationUtils {
    private static final String AUTH_HEADER_NAME = "Authorization";
    static final String CODE_PARAM = "code";
    static final String GRAND_TYPE_PARAM = "grant_type";
    static final String GRAND_TYPE_PARAM_VALUE = "authorization_code";
    static final String APP_REDIRECT_URL = "redirect_uri";

    static String createAuthHeader(String clientId, String clientSecret) {
        String up = clientId + ':' + clientSecret;
        return "Basic " + Base64.getEncoder().encodeToString(up.getBytes(StandardCharsets.UTF_8));
    }

    static Promise<OAuth2TokenResponse> exchangeAuthCodeForJwtToken(String code, URI tokenEndpoint, String clientId, String clientSecret, URI appRedirectUrl, Map<String, List<String>> queryParams) {
        HttpPost post = new HttpPost(tokenEndpoint);
        post.addHeader(AUTH_HEADER_NAME, OAuth2AuthenticationUtils.createAuthHeader(clientId, clientSecret));
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(CODE_PARAM, code));
        params.add(new BasicNameValuePair(GRAND_TYPE_PARAM, GRAND_TYPE_PARAM_VALUE));
        params.add(new BasicNameValuePair(APP_REDIRECT_URL, appRedirectUrl.toString()));
        for (Map.Entry<String, List<String>> e : queryParams.entrySet()) {
            for (String paramValue : e.getValue()) {
                params.add(new BasicNameValuePair(e.getKey(), paramValue));
            }
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)entity);
        URI proxyHost = Config.get().getHttpProxy();
        if (proxyHost != null) {
            post.setConfig(AsyncClientUtils.createRequestConfig(proxyHost));
        }
        try {
            return HttpResponseController.doPost(post, SslTrust.getTrustStore(), null).thenApply(response -> {
                byte[] content;
                HttpStatus status = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
                if (status.series() == HttpStatus.Series.CLIENT_ERROR || status.series() == HttpStatus.Series.SERVER_ERROR) {
                    throw new RuntimeException("Failed to acquire authentication token: " + response.getStatusLine());
                }
                try {
                    content = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (content == null) {
                    throw new RuntimeException("No content in response.");
                }
                try {
                    return SerializationUtil.fromByteArray(content, OAuth2TokenResponse.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
    }

    static Promise<SamlToken> exchangeJwtForSamlToken(LsppService ssoReg, LsppServiceEndpoint vapiEp, SsoContext ssoContext, String jwtToken, String idToken) {
        LsppServiceEndpoint adminEp;
        try {
            adminEp = SsoUtils.getAdminEndpoint((LsppService)ssoReg);
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
        Promise signCerts = Promises.from(() -> SsoFacade.getSsoSignCertificates((LsppServiceEndpoint)adminEp));
        return OAuth2AuthenticationUtils.exchangeJwtForSamlToken(vapiEp, ssoContext.getSolutionUserTokenProvider(), jwtToken, idToken).thenCombine(signCerts, (tokenInfo, certs) -> {
            String decodedToken = new String(Base64.getDecoder().decode(tokenInfo.getAccessToken()));
            try {
                return DefaultTokenFactory.createToken((String)decodedToken, (X509Certificate[])certs, (long)ssoContext.getClockTolerance());
            }
            catch (InvalidTokenException e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
        });
    }

    private static Promise<TokenExchangeTypes.Info> exchangeJwtForSamlToken(LsppServiceEndpoint vapiEp, TokenProvider suTokenProvider, String jwtToken, String idToken) {
        KeyStore sslStore;
        try {
            sslStore = CertificateUtils.createTrustStore((Collection)vapiEp.getCertificates());
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
        return OAuth2AuthenticationUtils.exchangeJwtForSamlToken(vapiEp.url, sslStore, suTokenProvider, jwtToken, idToken);
    }

    private static Promise<TokenExchangeTypes.Info> exchangeJwtForSamlToken(URI vapiUrl, KeyStore vapiSslStore, TokenProvider suTokenProvider, String jwtToken, String idToken) {
        int socketTimeout;
        int connectTimeout;
        try {
            connectTimeout = (int)Config.get().getConnectTimeout();
            socketTimeout = (int)Config.get().getSocketTimeout();
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
        VapiServiceImpl service = new VapiServiceImpl(vapiUrl, vapiSslStore, connectTimeout, socketTimeout);
        TokenExchange tokenExchange = service.createStub(TokenExchange.class);
        AsyncCallbackPromise<TokenExchangeTypes.Info> result = new AsyncCallbackPromise<TokenExchangeTypes.Info>();
        result.materialize().onSuccess(unused -> service.dispose());
        TokenExchangeTypes.ExchangeSpec spec = new TokenExchangeTypes.ExchangeSpec();
        spec.setGrantType("urn:ietf:params:oauth:grant-type:token-exchange");
        spec.setSubjectToken(jwtToken);
        spec.setSubjectTokenType("urn:ietf:params:oauth:token-type:access_token");
        spec.setActorToken(idToken);
        spec.setActorTokenType("urn:ietf:params:oauth:token-type:id_token");
        spec.setRequestedTokenType("urn:ietf:params:oauth:token-type:saml2");
        ExecutionContext ec = new ExecutionContext(SecurityContextFactory.createSamlSecurityContext((SamlToken)suTokenProvider.getToken(), (PrivateKey)suTokenProvider.getPrivateKey()));
        tokenExchange.exchange(spec, result, new InvocationConfig(ec));
        return result;
    }

    public static final class OAuth2TokenResponse {
        @JsonProperty(value="access_token")
        public String accessToken;
        @JsonProperty(value="refresh_token")
        public String refreshToken;
        @JsonProperty(value="id_token")
        public String idToken;
        @JsonProperty(value="token_type")
        public String tokenType;
        @JsonProperty(value="expires_in")
        public int expiresIn;
        @JsonProperty(value="scope")
        public String scope;
    }
}

