/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.pc.utils;

import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.topology.impl.vmomi.srm.SrmServiceImpl;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class ObjectSpecBuilder {
    private static final String VC_PKG = "com.vmware.vim.binding.vim";
    private static final String SRM_PKG = "com.vmware.vim.binding.dr";
    private static final ClassLoader VC_LOADER;
    private static final ClassLoader SRM_LOADER;
    private final PropertyCollector.ObjectSpec _objSpec = new PropertyCollector.ObjectSpec();
    private final ManagedObjectType _rootMoType;
    private final List<TraversalSpecBuilder> _traversals = new LinkedList<TraversalSpecBuilder>();

    static TraversalSpecBuilder traverseToImpl(ManagedObjectType moType, String property, boolean skip) {
        ManagedObjectType vmodlType = moType;
        String[] nestedProps = property.split("\\.");
        for (int i = 0; i < nestedProps.length; ++i) {
            String current = nestedProps[i];
            VmodlField vmodlProperty = PCUtil.getVmodlProperty((VmodlType)vmodlType, current);
            if (vmodlProperty == null) {
                throw new IllegalArgumentException("Invalid property [" + current + "] for type [" + vmodlType + "].");
            }
            vmodlType = ObjectSpecBuilder.getVmodlType(vmodlProperty);
            if (vmodlType == null) {
                throw new IllegalArgumentException("Unable to get vmodlType for " + vmodlProperty.getName());
            }
            if (!(vmodlType instanceof ManagedObjectType) || i == nestedProps.length - 1) continue;
            throw new IllegalArgumentException("Intermediate managed property [" + vmodlProperty + "] found.");
        }
        if (!ManagedObjectType.class.isInstance(vmodlType)) {
            throw new IllegalArgumentException("The type of [" + property + "] is not ManagedObject.");
        }
        return new TraversalSpecBuilder(property, vmodlType, moType.getWsdlName(), skip);
    }

    private static Class<? extends ManagedObject> getManagedObjectClass(String className) throws ClassNotFoundException {
        ClassLoader loader;
        if (className.startsWith(VC_PKG)) {
            loader = VC_LOADER;
        } else if (className.startsWith(SRM_PKG)) {
            loader = SRM_LOADER;
        } else {
            throw new IllegalArgumentException("Unsupported class " + className);
        }
        return Class.forName(className, false, loader);
    }

    static VmodlType getVmodlType(VmodlField vmodlProperty) {
        if (vmodlProperty instanceof ManagedProperty) {
            Class<? extends ManagedObject> javaClass;
            Method method = ((ManagedProperty)vmodlProperty).getAccessor().getMethod();
            managedObjectType moTypeAnnotation = method.getAnnotation(managedObjectType.class);
            if (moTypeAnnotation == null) {
                return vmodlProperty.getType();
            }
            String className = moTypeAnnotation.value();
            try {
                javaClass = ObjectSpecBuilder.getManagedObjectClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
            return VmodlTypeMap.Factory.getTypeMap().getVmodlType(javaClass);
        }
        VmodlType type = vmodlProperty.getType();
        if (type.getKind() == VmodlType.Kind.ARRAY) {
            type = ((VmodlArrayType)type).getComponentType();
        }
        if (type.getKind() == VmodlType.Kind.MOREF) {
            return (ManagedObjectType)vmodlProperty.getManagedObjectType();
        }
        return type;
    }

    public ObjectSpecBuilder(ManagedObjectReference moRef) {
        this(moRef, false);
    }

    public ObjectSpecBuilder(ManagedObjectReference moRef, boolean skip) {
        Validate.notNull((Object)moRef, (String)"moRef");
        Validate.notNull((Object)moRef.getType(), (String)"moRef.type");
        String type = moRef.getType();
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(type);
        if (!ManagedObjectType.class.isInstance(vmodlType)) {
            throw new IllegalArgumentException("Unknown mo type " + type);
        }
        this._objSpec.obj = moRef;
        this._objSpec.skip = skip;
        this._rootMoType = (ManagedObjectType)vmodlType;
    }

    public TraversalSpecBuilder traverseTo(String property) {
        return this.traverseTo(property, false);
    }

    public TraversalSpecBuilder traverseTo(String property, boolean skip) {
        Validate.notEmpty((String)property, (String)"property");
        TraversalSpecBuilder result = ObjectSpecBuilder.traverseToImpl(this._rootMoType, property, skip);
        this._traversals.add(result);
        return result;
    }

    public PropertyCollector.ObjectSpec build() {
        ArrayList<PropertyCollector.SelectionSpec> trSpecs = new ArrayList<PropertyCollector.SelectionSpec>(this._traversals.size());
        for (TraversalSpecBuilder tsb : this._traversals) {
            trSpecs.add(tsb.build());
        }
        this._objSpec.selectSet = trSpecs.toArray(new PropertyCollector.SelectionSpec[trSpecs.size()]);
        return this._objSpec;
    }

    static {
        try {
            SrmServiceImpl.VMODL_INIT.waitToComplete();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        VC_LOADER = ServiceInstance.class.getClassLoader();
        SRM_LOADER = com.vmware.vim.binding.dr.ServiceInstance.class.getClassLoader();
    }

    public static class TraversalSpecBuilder {
        private final String _moType;
        private final ManagedObjectType _propertyType;
        private final String _property;
        private final boolean _skip;
        private final String _name;
        private final List<TraversalSpecBuilder> _traversals = new LinkedList<TraversalSpecBuilder>();
        private final List<String> _loops = new LinkedList<String>();

        protected TraversalSpecBuilder(String property, ManagedObjectType propertyType, String moType, boolean skip) {
            Validate.notEmpty((String)property, (String)"property");
            Validate.notNull((Object)propertyType, (String)"propertyType");
            Validate.notEmpty((String)moType, (String)"moType");
            this._moType = moType;
            this._propertyType = propertyType;
            this._property = property;
            this._name = "to" + moType + property;
            this._skip = skip;
        }

        public String getName() {
            return this._name;
        }

        public TraversalSpecBuilder traverseTo(String property) {
            return this.traverseTo(property, false);
        }

        public TraversalSpecBuilder traverseTo(String property, boolean skip) {
            Validate.notEmpty((String)property, (String)"property");
            TraversalSpecBuilder result = ObjectSpecBuilder.traverseToImpl(this._propertyType, property, skip);
            this._traversals.add(result);
            return result;
        }

        public TraversalSpecBuilder traverseTo(String type, String property) {
            return this.traverseTo(type, property, false);
        }

        public TraversalSpecBuilder traverseTo(String type, String property, boolean skip) {
            Validate.notEmpty((String)type, (String)"type");
            Validate.notEmpty((String)property, (String)"property");
            VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(type);
            if (!ManagedObjectType.class.isInstance(vmodlType)) {
                throw new IllegalArgumentException("Unknown mo type " + type);
            }
            ManagedObjectType moType = (ManagedObjectType)vmodlType;
            Class moTypeClass = moType.getTypeClass();
            Class propertyTypeClass = this._propertyType.getTypeClass();
            if (!propertyTypeClass.isAssignableFrom(moTypeClass)) {
                throw new IllegalArgumentException(propertyTypeClass + " not assignable to " + moTypeClass);
            }
            TraversalSpecBuilder result = ObjectSpecBuilder.traverseToImpl(moType, property, skip);
            this._traversals.add(result);
            return result;
        }

        public TraversalSpecBuilder loopTo(String selectionSpecName) {
            Validate.notEmpty((String)selectionSpecName, (String)"selectionSpecName");
            this._loops.add(selectionSpecName);
            return this;
        }

        protected PropertyCollector.SelectionSpec build() {
            PropertyCollector.TraversalSpec trSpec = new PropertyCollector.TraversalSpec();
            trSpec.skip = this._skip;
            trSpec.name = this._name;
            trSpec.path = this._property;
            trSpec.type = PCUtil.getTypeName(this._moType);
            ArrayList<PropertyCollector.SelectionSpec> trSpecs = new ArrayList<PropertyCollector.SelectionSpec>(this._traversals.size() + this._loops.size());
            for (TraversalSpecBuilder trSpecBuilder : this._traversals) {
                trSpecs.add(trSpecBuilder.build());
            }
            for (String selectSetName : this._loops) {
                trSpecs.add(new PropertyCollector.SelectionSpec(selectSetName));
            }
            trSpec.selectSet = trSpecs.toArray(new PropertyCollector.SelectionSpec[trSpecs.size()]);
            return trSpec;
        }
    }
}

