/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;

public class IndexUtils {
    public static <K, V> Map<K, List<V>> indexBy(Collection<V> coll, Indexer<K, V> indexer) {
        if (CollectionUtils.isEmpty(coll)) {
            return Collections.emptyMap();
        }
        HashMap<K, ArrayList<V>> result = new HashMap<K, ArrayList<V>>();
        for (V value : coll) {
            K key = indexer.getKey(value);
            ArrayList<V> values = (ArrayList<V>)result.get(key);
            if (values == null) {
                values = new ArrayList<V>();
                result.put(key, values);
            }
            values.add(value);
        }
        return result;
    }

    public static Map<String, List<ManagedObjectReference>> indexByGuid(Collection<ManagedObjectReference> morefs) {
        Map<String, List<ManagedObjectReference>> guid2moref = IndexUtils.indexBy(morefs, new Indexer<String, ManagedObjectReference>(){

            @Override
            public String getKey(ManagedObjectReference value) {
                Validate.notNull((Object)value, (String)"value");
                return value.getServerGuid();
            }
        });
        return guid2moref;
    }

    public static interface Indexer<K, V> {
        public K getKey(V var1);
    }
}

