/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.token.impl;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509TrustChainKeySelector
extends KeySelector {
    private static final String BUILDER_PROVIDER_PKIX = "PKIX";
    private static final String BCFIPS_PROVIDER = "BCFIPS";
    private static final String CERTSTORE_PROVIDER_COLLECTION = "Collection";
    private static final String UNRECOGNIZED_DS_KEYINFO = "Unrecognized <ds:KeyInfo> element";
    private final Logger _log = LoggerFactory.getLogger(X509TrustChainKeySelector.class);
    private final Set<TrustAnchor> _trustAnchors;

    public X509TrustChainKeySelector(X509Certificate ... trustedRoots) {
        X509TrustChainKeySelector.checkCtorArgsNotNull(trustedRoots);
        this._trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate cert : trustedRoots) {
            this._trustAnchors.add(new TrustAnchor(cert, null));
        }
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (purpose != KeySelector.Purpose.VERIFY) {
            this._log.warn("Incorrect usage: this selector only returns verification keys");
            return this.fixedKeyResult(null);
        }
        List<X509Certificate> keyInfoCertificates = this.extractCertificateList(keyInfo);
        if (keyInfoCertificates.isEmpty()) {
            if (this._trustAnchors.size() == 1) {
                return this.fixedKeyResult(this._trustAnchors.iterator().next().getTrustedCert().getPublicKey());
            }
            return this.fixedKeyResult(null);
        }
        X509Certificate signingCertificate = keyInfoCertificates.get(0);
        if (this.verifyTrustedPathExists(signingCertificate, keyInfoCertificates)) {
            return this.fixedKeyResult(signingCertificate.getPublicKey());
        }
        return this.fixedKeyResult(null);
    }

    private List<X509Certificate> extractCertificateList(KeyInfo keyInfo) {
        if (keyInfo == null) {
            return Collections.emptyList();
        }
        if (keyInfo.getContent().size() != 1 || !(keyInfo.getContent().get(0) instanceof X509Data)) {
            this._log.info("Unrecognized <ds:KeyInfo> element: should have just one child of type <ds:X509Data>");
            return Collections.emptyList();
        }
        X509Data x509Data = (X509Data)keyInfo.getContent().get(0);
        List<?> x509Certificates = x509Data.getContent();
        ArrayList<X509Certificate> extracted = new ArrayList<X509Certificate>();
        for (Object cert : x509Certificates) {
            if (!(cert instanceof X509Certificate)) continue;
            extracted.add((X509Certificate)cert);
        }
        return extracted;
    }

    private boolean verifyTrustedPathExists(X509Certificate target, Collection<X509Certificate> nodes) throws KeySelectorException {
        try {
            CertPathBuilder pathBuilder = CertPathBuilder.getInstance(BUILDER_PROVIDER_PKIX);
            if (pathBuilder.getProvider().contains(BCFIPS_PROVIDER)) {
                this._log.debug("using BCFIPS provider, check target certificate");
                for (TrustAnchor trustAnchor : this._trustAnchors) {
                    X509Certificate trustedCert = trustAnchor.getTrustedCert();
                    if (trustedCert == null || !trustedCert.equals(target)) continue;
                    this._log.debug("target same as trust anchor, skipping CertPathBuilder");
                    return true;
                }
            }
            CertStore builderStore = CertStore.getInstance(CERTSTORE_PROVIDER_COLLECTION, new CollectionCertStoreParameters(nodes));
            X509CertSelector certSelector = new X509CertSelector();
            certSelector.setCertificate(target);
            PKIXBuilderParameters buildParams = new PKIXBuilderParameters(this._trustAnchors, (CertSelector)certSelector);
            buildParams.addCertStore(builderStore);
            buildParams.setRevocationEnabled(false);
            CertPathBuilderResult builderResult = pathBuilder.build(buildParams);
            if (this._log.isDebugEnabled()) {
                this.dumpPathBuilderResult((PKIXCertPathBuilderResult)builderResult);
            }
            return true;
        }
        catch (CertPathBuilderException e) {
            this._log.info("Failed to find trusted path to signing certificate <" + target.getSubjectX500Principal().getName() + ">", (Throwable)e);
            return false;
        }
        catch (GeneralSecurityException e) {
            String message = "Couldnt't create standard security object. Possibly non-compliant underlying Java implementation.";
            this._log.error(message, (Throwable)e);
            throw new KeySelectorException(message, e);
        }
    }

    private KeySelectorResult fixedKeyResult(final Key key) {
        return new KeySelectorResult(){

            @Override
            public Key getKey() {
                return key;
            }
        };
    }

    private void dumpPathBuilderResult(PKIXCertPathBuilderResult builderResult) {
        StringBuilder message = new StringBuilder("Trusted path found: ");
        for (Certificate certificate : builderResult.getCertPath().getCertificates()) {
            message.append('<').append(((X509Certificate)certificate).getSubjectX500Principal().getName()).append("> -> ");
        }
        message.append('<').append(builderResult.getTrustAnchor().getTrustedCert().getSubjectX500Principal().getName()).append('>');
        this._log.debug(message.toString());
    }

    private static void checkCtorArgsNotNull(X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            throw new IllegalArgumentException("Expected one or more trusted certificates, but got null");
        }
        for (X509Certificate cert : certs) {
            if (cert != null) continue;
            throw new IllegalArgumentException("Expected certificate, but got null");
        }
    }
}

