/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.Utils;
import emitters.Versions;
import emitters.backend.Platform;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class VmodlEmitter {
    protected final Map<String, String> _emitterOptions;
    private final String _eol = "\n";
    private boolean _hideInternalDecls = true;
    private boolean _hideUndocumentedDecls = true;
    private int _indent = 0;
    private String _filename = null;
    private StringBuilder _buffer = null;
    private boolean _newline = true;
    private boolean _gap = true;
    public static Map<String, String> _packageMap = new HashMap<String, String>();
    protected static Set<String> _builtins = new HashSet<String>();

    protected VmodlEmitter() {
        this._emitterOptions = null;
    }

    protected VmodlEmitter(Map<String, String> options) {
        this._emitterOptions = options;
    }

    protected VmodlEmitter(Map<String, String> options, String filename) {
        this(options);
        this.beginFile(filename);
    }

    public boolean isBindingEmitter() {
        return false;
    }

    public boolean nonDynamicEmitter() {
        return false;
    }

    public void processOptions() {
    }

    public void setHideInternalDecls(boolean hide) {
        this._hideInternalDecls = hide;
    }

    public boolean hideInternalDecls() {
        return this._hideInternalDecls;
    }

    public void setHideUndocumentedDecls(boolean hide) {
        this._hideUndocumentedDecls = hide;
    }

    public boolean hideUndocumentedDecls() {
        return this._hideUndocumentedDecls;
    }

    public boolean shouldGenerateFor(Parameter param) {
        Version paramVersion = param.getVersion();
        if (paramVersion == null) {
            return true;
        }
        return Versions.getTargetVersion().isAncestor(paramVersion);
    }

    protected boolean shouldGenerate(VmodlApi vmodlApi) {
        if (this._hideUndocumentedDecls && vmodlApi.isUndocumented()) {
            return false;
        }
        if (this._hideInternalDecls && Versions.isInternalAtTarget(vmodlApi)) {
            return false;
        }
        return Versions.isTargetNewerThan(vmodlApi.getVersion());
    }

    public boolean shouldGenerateFor(VmodlObject obj, Method method) {
        return this.shouldGenerate(method);
    }

    public boolean shouldGenerateFor(VmodlObject obj, Property prop) {
        return this.shouldGenerate(prop);
    }

    public boolean shouldGenerateFor(VmodlObject obj) {
        return this.shouldGenerate(obj);
    }

    protected void beginFile(String filename) {
        if (this._filename != null || this._buffer != null) {
            throw new RuntimeException("beginFile called twice without endFile");
        }
        this._indent = 0;
        this._filename = filename;
        this._buffer = new StringBuilder();
        this._newline = true;
        this._gap = true;
    }

    protected void endFile(String filename, StringBuilder builder) {
        if (filename == null || builder == null) {
            throw new RuntimeException("endFile called without beginFile");
        }
        boolean unchanged = false;
        String buffer = builder.toString();
        File file = Platform.getFileHandle(filename);
        int size = (int)file.length();
        if (size == builder.length()) {
            try {
                FileReader reader = new FileReader(file);
                char[] data = new char[size];
                reader.read(data, 0, size);
                reader.close();
                String contents = new String(data);
                if (contents.equals(buffer)) {
                    unchanged = true;
                }
            }
            catch (IOException e) {
                System.err.println("Can't read source '" + filename + "' -- assuming changed");
            }
        }
        if (!unchanged) {
            PrintWriter writer = Platform.createTextFile(new File(filename));
            writer.print(buffer);
            writer.close();
        }
    }

    protected void endFile() {
        this.endFile(this._filename, this._buffer);
        this._buffer = null;
        this._filename = null;
    }

    protected String getIndentGap() {
        return "   ";
    }

    protected void indent() {
        ++this._indent;
    }

    protected void indent(String s) {
        this.emitLine(s);
        ++this._indent;
    }

    protected void unindent() {
        --this._indent;
    }

    protected void unindent(int levels) {
        this._indent -= levels;
    }

    protected void unindent(String s) {
        --this._indent;
        this.emitLine(s);
    }

    private void doIndent() {
        if (this._newline) {
            int indent = this._indent;
            while (--indent >= 0) {
                this._buffer.append(this.getIndentGap());
            }
            this._newline = false;
        }
    }

    private void endLine() {
        this._gap = this._newline;
        this._buffer.append("\n");
        this._newline = true;
    }

    protected void emitGap() {
        if (!this._gap) {
            this.endLine();
        }
    }

    protected void emitLine() {
        this.endLine();
    }

    protected void emitLine(String s) {
        this.emitPartial(s);
        this.endLine();
    }

    protected void emitLine(String ... strs) {
        this.emitPartial(strs);
        this.endLine();
    }

    protected void emitPartial(String s) {
        this.doIndent();
        this._buffer.append(s);
    }

    protected void emitPartial(String ... strs) {
        if (strs != null) {
            this.doIndent();
            for (String s : strs) {
                this._buffer.append(s);
            }
        }
    }

    protected void emitList(List<String> list, String sep, boolean endLine) {
        boolean first = true;
        for (String elt : list) {
            if (!first) {
                this.emitPartial(sep);
            }
            this.emitPartial(elt);
            if (endLine) {
                this.emitLine();
            }
            first = false;
        }
    }

    protected static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    protected static String qq(String s) {
        return "\"" + s + "\"";
    }

    protected static String qb(String s) {
        return "<" + s + ">";
    }

    protected static String qs(String s) {
        return "'" + s + "'";
    }

    public static String join(Collection<?> list, String sep) {
        StringBuilder sbuf = new StringBuilder();
        boolean first = true;
        for (Object elt : list) {
            if (!first) {
                sbuf.append(sep);
            }
            sbuf.append(elt);
            first = false;
        }
        return sbuf.toString();
    }

    protected static String join(Collection<?> list) {
        return VmodlEmitter.join(list, ", ");
    }

    protected String getFilename() {
        return this._filename;
    }

    protected String getLineSeparator() {
        return "\n";
    }

    public abstract void emitObjects(List<VmodlObject> var1);

    protected void insertVersion(List<Version> list, Version version) {
        boolean found = false;
        for (int i = 0; i < list.size(); ++i) {
            Version vPos = list.get(i);
            if (vPos == version) {
                found = true;
                break;
            }
            if (!Versions.isAncestor(vPos, version)) continue;
            list.add(i, version);
            found = true;
            break;
        }
        if (!found) {
            list.add(version);
        }
    }

    public static String namespace(String pkg) {
        ArrayList<String> nsList = new ArrayList<String>();
        for (String ns : pkg.split("[.]")) {
            ns = _packageMap.containsKey(ns) ? _packageMap.get(ns) : Utils.capitalize(ns);
            if (ns.length() <= 0) continue;
            nsList.add(ns);
        }
        return VmodlEmitter.join(nsList, ".");
    }

    public static String rootNamespace(String pkg) {
        return pkg.split("[.]")[0];
    }

    protected static boolean isBuiltin(VmodlObject obj) {
        return _builtins.contains(obj.getQualifiedVmodlType());
    }

    static {
        _builtins.add(Utils.MethodFaultClassName);
        _builtins.add(Utils.RuntimeFaultClassName);
        _builtins.add(Utils.DataObjectClassName);
        _builtins.add(Utils.ManagedObjectClassName);
    }
}

