/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.csharp;

import emitters.Utils;
import emitters.VmodlEmitter;
import emitters.bindings.csharp.Common;
import emitters.bindings.csharp.CsStubEmitter;
import emitters.model.DataObject;
import emitters.model.ManagedObject;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CsMetaTypeEmitter
extends VmodlEmitter {
    public static final String METHODNAME_TYPENAME = "MethodName";
    public static final String PROPPATH_TYPENAME = "PropertyPath";
    public static final String DAO_UID_PROP_VMODLNAME = "key";
    private final String ARRAY_LEN_PROPNAME = "length";
    public static final String METATYPE_NS = "VmomiSupport.MetaTypes";
    private final String METATYPE_NS_PREFIX = "VmomiSupport.MetaTypes.";
    private final String STUB_NS_ALIAS_PREFIX = "Stub";
    private final String BASE_METATYPE_NAME = "PropertyContainer";
    private final String INT_ARRAY_TYPENAME = "IntArray";
    private final String STRING_ARRAY_TYPENAME = "StringArray";
    private final String MANAGED_OBJECT_ARRAY_TYPENAME = "ManagedObjectArray";
    private final String FILENAME_SEPARATOR = System.getProperty("file.separator");
    private String _stubsFilename;
    private String _outputDirPath;
    private String _filename;
    private String _currentNamespace = null;
    private boolean _emitPrimitives = false;
    private LinkedList<VmodlObject> _classesBeingEmitted = new LinkedList();
    private Map<DataObject, Property> _keyProperties = new HashMap<DataObject, Property>();

    CsMetaTypeEmitter(Map<String, String> options, String stubsFilename) {
        super(options);
        this._stubsFilename = stubsFilename;
    }

    @Override
    public void processOptions() {
        for (Map.Entry entry : this._emitterOptions.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals("primitives")) {
                this._emitPrimitives = true;
                continue;
            }
            if (!key.equals("type.support.dir")) continue;
            this._outputDirPath = value;
            if (this._outputDirPath.length() <= 0) continue;
            this._outputDirPath = this._outputDirPath + this.FILENAME_SEPARATOR;
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        String[] filenameSeparators = new String[]{this.FILENAME_SEPARATOR, "/"};
        String unqualifiedStubsFilename = Common.lastWord(this._stubsFilename, filenameSeparators);
        this._filename = this._outputDirPath + Common.removeLastWord(unqualifiedStubsFilename, ".") + ".MetaTypes.cs";
        this.beginFile(this._filename);
        this.emitFileHeader(objects);
        for (VmodlObject obj : objects) {
            String namespace = CsStubEmitter.csharpNamespaced(obj.getNamespace());
            if (!namespace.equals(this._currentNamespace)) {
                this.emitEndNamespace();
                this._currentNamespace = namespace;
                this.emitBeginNamespace();
            }
            this.emitObject(obj);
        }
        this.emitEndNamespace();
        this.endFile();
    }

    private static String getTopNamespace(VmodlObject obj) {
        String namespace = CsStubEmitter.csharpNamespaced(obj.getNamespace());
        String topNamespace = Common.firstWord(namespace, ".");
        return topNamespace;
    }

    private static Collection<String> getTopNamespaces(Collection<VmodlObject> objects) {
        HashSet<String> topNamespaces = new HashSet<String>();
        if (objects == null) {
            return topNamespaces;
        }
        for (VmodlObject obj : objects) {
            topNamespaces.add(CsMetaTypeEmitter.getTopNamespace(obj));
            for (Property prop : obj.getPropertyList()) {
                VmodlObject pObj;
                if (CsStubEmitter.systemTypeName(prop.getDecl(), false) != null || (pObj = prop.getDecl().getObject()) == null) continue;
                topNamespaces.add(CsMetaTypeEmitter.getTopNamespace(prop.getDecl().getObject()));
            }
            Collection<String> nestedNs = CsMetaTypeEmitter.getTopNamespaces(obj.getNestedList());
            for (String ns : nestedNs) {
                topNamespaces.add(ns);
            }
        }
        return topNamespaces;
    }

    private void emitFileHeader(List<VmodlObject> objects) {
        Collection<String> topNamespaces = CsMetaTypeEmitter.getTopNamespaces(objects);
        this.emitLine("/******** WARNING - AUTO GENERATED CODE - DO NOT EDIT ********/");
        this.emitLine();
        this.emitLine("using System;");
        this.emitLine("using VirtualInfrastructure;");
        for (String topNamespace : topNamespaces) {
            this.emitLine("using Stub" + topNamespace + " = " + topNamespace + ";");
        }
        this.emitLine();
        if (this._emitPrimitives) {
            this.emitPrimitives();
        }
    }

    private void emitBeginNamespace() {
        this.emitLine("namespace VmomiSupport.MetaTypes." + this._currentNamespace + " {");
        this.emitLine();
    }

    private void emitEndNamespace() {
        if (this._currentNamespace != null) {
            this.emitLine();
            this.emitLine("} // namespace VmomiSupport.MetaTypes." + this._currentNamespace);
        }
    }

    private void emitObject(VmodlObject obj) {
        if (obj instanceof ManagedObject) {
            this.emitManagedObject((ManagedObject)obj);
        } else if (obj instanceof DataObject) {
            this.emitDataObject((DataObject)obj);
        }
    }

    private void emitManagedObject(ManagedObject mo) {
        this.emitBeginClass(mo);
        this.emitLine();
        String className = CsStubEmitter.csharpTypeName(mo, CsStubEmitter.NameQualification.Unqualified);
        this.emitLine("static ", className, "() {");
        this.indent();
        this.emitMethodNameInitializers(mo);
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        this.emitMethodNames(mo, "");
        this.emitLine();
        this.emitProperties(mo);
        this.emitEndClass(mo);
    }

    private void emitProperties(VmodlObject obj) {
        for (Property prop : obj.getPropertyList()) {
            this.emitProperty(obj, prop);
        }
    }

    private void emitMethodNames(ManagedObject mo, String modifier) {
        VmodlObject baseObj = mo.getBaseObject();
        if (baseObj instanceof ManagedObject) {
            this.emitMethodNames((ManagedObject)baseObj, "new ");
        }
        for (Method method : mo.getMethodList()) {
            this.emitMethod(method.getName(), method.getWsdlName(), modifier);
        }
        for (Property prop : mo.getPropertyList()) {
            ManagedProperty moProp = (ManagedProperty)prop;
            this.emitMethod(moProp.getAccessor().getName(), null, modifier);
            if (prop.isReadonly()) continue;
            this.emitMethod(moProp.getMutator().getName(), null, modifier);
        }
    }

    private void emitDataObject(DataObject dao) {
        this.emitBeginClass(dao);
        this.emitProperties(dao);
        this.emitEndClass(dao);
    }

    private void emitBeginClass(VmodlObject obj) {
        this._classesBeingEmitted.addLast(obj);
        String className = CsStubEmitter.csharpTypeName(obj, CsStubEmitter.NameQualification.Unqualified);
        String staticPropertyModifier = "";
        String classDefnModifier = "";
        String baseName = this.typeName(obj.getBaseObject(), "PropertyContainer");
        if (!baseName.equals("PropertyContainer")) {
            staticPropertyModifier = "new ";
        }
        if (Common.conflictingContainerNestedType(obj) != null) {
            classDefnModifier = classDefnModifier + "new ";
        }
        this.emitLine("public " + classDefnModifier + "class " + className + " : " + baseName);
        this.emitLine("{");
        this.indent();
        this.emitLine("public " + className + "(Type pt, string pp) : base(pt, pp) {}");
        if (obj instanceof ManagedObject || obj instanceof DataObject) {
            String fullClassName = CsStubEmitter.csharpTypeName(obj, CsStubEmitter.NameQualification.Qualified);
            this.emitLine("private static Type MirroredType = typeof(Stub" + fullClassName + ");");
            this.emitLine("protected override Type GetMyType() { return MirroredType; }");
            this.emitLine("public static " + staticPropertyModifier + className + " PropertyPath { get { return new " + className + "(MirroredType, " + CsMetaTypeEmitter.qq("") + "); } }");
            this.emitLine();
        }
    }

    private void emitEndClass(VmodlObject obj) {
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitObject(nestedObj);
        }
        this.unindent();
        String className = CsStubEmitter.csharpTypeName(obj, CsStubEmitter.NameQualification.Unqualified);
        this.emitLine("} // class " + className);
        this._classesBeingEmitted.removeLast();
        this.emitArrayObject(obj);
    }

    private void emitPrimitiveArrays() {
        this.emitIndexedType("IntArray", "int", PROPPATH_TYPENAME, "");
        this.emitIndexedType("StringArray", "string", PROPPATH_TYPENAME, "");
        this.emitIndexedType("ManagedObjectArray", "ManagedObject", PROPPATH_TYPENAME, "");
    }

    private void emitPrimitives() {
        this.emitLine("namespace VmomiSupport.MetaTypes {");
        this.emitLine();
        this.emitPrimitiveArrays();
        this.emitLine();
        this.emitLine("}");
    }

    private void emitArrayObject(VmodlObject obj) {
        String keyGetter = "";
        if (obj instanceof DataObject && this.containsArrayKeyableProperty((DataObject)obj)) {
            Property keyProp = this.arrayKeyableProperty((DataObject)obj);
            keyGetter = CsStubEmitter.propertyIdentifier(obj, keyProp);
        } else if (!(obj instanceof ManagedObject)) {
            return;
        }
        String typeName = CsStubEmitter.csharpTypeName(obj, CsStubEmitter.NameQualification.Unqualified);
        String fullTypeName = CsStubEmitter.csharpTypeName(obj, CsStubEmitter.NameQualification.Qualified);
        if (!"MethodDescription".equals(typeName)) {
            this.emitIndexedType(typeName + "Array", "Stub" + fullTypeName, typeName, keyGetter);
        }
    }

    private void emitIndexedType(String className, String keyTypename, String valTypename, String keyGetter) {
        String keyIdentifier;
        this.emitLine("public class " + className + " : " + "PropertyContainer");
        this.emitLine("{");
        this.indent();
        this.emitLine("public " + className + "(Type pt, string pp) : base(pt, pp) {}");
        String ppKey = keyIdentifier = DAO_UID_PROP_VMODLNAME;
        if (keyGetter.length() > 0) {
            ppKey = ppKey + "." + keyGetter;
        }
        String indexer = String.format("public %s this[%s %s] { get { return new %s(_Provider, _Path + QK(%s)); } }", valTypename, keyTypename, keyIdentifier, valTypename, ppKey);
        this.emitLine(indexer);
        this.emitLine("public PropertyPath Length { get { return new PropertyPath(_Provider, _Path + _Resolver + " + CsMetaTypeEmitter.qq("length") + "); } }");
        this.unindent();
        this.emitLine("} // class " + className);
    }

    private void emitMethodNameInitializers(ManagedObject mo) {
        this.emitLine("MethodNameProvider provider = new MethodNameProvider(MirroredType);");
        for (Method method : mo.getFullMethodList()) {
            this.emitMethodInit(method);
        }
        for (Property prop : mo.getFullPropertyList()) {
            ManagedProperty moProp = (ManagedProperty)prop;
            this.emitMethodInit(moProp.getAccessor());
            if (prop.isReadonly()) continue;
            this.emitMethodInit(moProp.getMutator());
        }
        this.emitLine();
    }

    private void emitMethodInit(Method method) {
        String vmodlMethodName = method.getName();
        String csMethodName = CsStubEmitter.csharpMethodIdentifier(vmodlMethodName);
        this.emitLine(csMethodName, " = provider[", CsMetaTypeEmitter.qq(csMethodName), ",", CsMetaTypeEmitter.qq(vmodlMethodName), "];");
    }

    private void emitMethod(String vmodlMethodName, String soapMethodName, String modifier) {
        String csMethodName = CsStubEmitter.csharpMethodIdentifier(vmodlMethodName);
        this.emitLine("public static readonly ", modifier, METHODNAME_TYPENAME, " ", csMethodName, " = null;");
    }

    private void emitProperty(VmodlObject propProvider, Property prop) {
        String csPropName = CsStubEmitter.propertyIdentifier(propProvider, prop);
        String vmodlPropName = prop.getName();
        String typeName = this.typeName(prop.getDecl(), PROPPATH_TYPENAME);
        String propertyType = "";
        if (PROPPATH_TYPENAME.equals(typeName)) {
            propertyType = CsStubEmitter.getCsharpTypeName(prop.getDecl(), CsStubEmitter.ArrayTypenameFlag.True, CsStubEmitter.ReflectedTypenameFlag.False);
            if (CsStubEmitter.systemTypeName(prop.getDecl(), false) == null) {
                propertyType = "Stub" + propertyType;
            }
            propertyType = ", typeof(" + propertyType + ")";
        }
        this.emitLine("public ", typeName, " ", csPropName, " { get { return new " + typeName, "(_Provider, _Path + _Resolver + ", CsMetaTypeEmitter.qq(vmodlPropName), propertyType, "); } }");
    }

    private String typeName(VmodlDecl decl, String defaultName) {
        VmodlObject obj = decl.getObject();
        if (decl.isPrimitive() || obj == null) {
            if (decl.isArray()) {
                switch (decl.getTypeId()) {
                    case INT: {
                        return "IntArray";
                    }
                    case STRING: {
                        return "StringArray";
                    }
                    case MANAGED: {
                        return "ManagedObjectArray";
                    }
                }
            }
            return defaultName;
        }
        return this.typeName(obj, defaultName, decl.isArray() ? ArrayTypenameFlag.True : ArrayTypenameFlag.False);
    }

    private String typeName(VmodlObject obj, String defaultName, ArrayTypenameFlag isArray) {
        String vmodlTypeName = obj.getQualifiedVmodlType();
        if (vmodlTypeName.equals(Utils.ManagedObjectClassName) || vmodlTypeName.equals(Utils.DataObjectClassName)) {
            return defaultName;
        }
        if (CsMetaTypeEmitter.isBuiltin(obj)) {
            return obj.getClassName();
        }
        if (isArray == ArrayTypenameFlag.False || obj instanceof ManagedObject || this.containsArrayKeyableProperty((DataObject)obj)) {
            String typeName = this.relativelyQualifiedTypename(obj);
            if (isArray == ArrayTypenameFlag.True) {
                typeName = typeName + "Array";
            }
            return typeName;
        }
        return defaultName;
    }

    private String typeName(VmodlObject obj, String defaultName) {
        return this.typeName(obj, defaultName, ArrayTypenameFlag.False);
    }

    private String relativelyQualifiedTypename(VmodlObject obj) {
        String typeName = CsStubEmitter.csharpTypeName(obj, CsStubEmitter.NameQualification.Qualified);
        VmodlObject enclosingClass = this._classesBeingEmitted.size() > 0 ? this._classesBeingEmitted.getLast() : null;
        typeName = CsStubEmitter.qualifyOnlyAsNecessary(typeName, obj, this._currentNamespace, enclosingClass);
        return typeName;
    }

    private boolean containsArrayKeyableProperty(DataObject obj) {
        return this.arrayKeyableProperty(obj) != null;
    }

    private Property arrayKeyableProperty(DataObject obj) {
        Property keyProp;
        if (this._keyProperties.containsKey(obj)) {
            keyProp = this._keyProperties.get(obj);
        } else {
            keyProp = Common.propertyByName(obj, DAO_UID_PROP_VMODLNAME);
            this._keyProperties.put(obj, keyProp);
        }
        if (keyProp != null && (keyProp.getDecl().getTypeId() == VmodlDecl.TypeId.TYPENAME || keyProp.getDecl().getTypeId() == VmodlDecl.TypeId.METHODNAME)) {
            return null;
        }
        if (keyProp != null && keyProp.getDecl().getTypeId() != VmodlDecl.TypeId.STRING && keyProp.getDecl().getTypeId() != VmodlDecl.TypeId.INT && keyProp.getDecl().getTypeId() != VmodlDecl.TypeId.MANAGED) {
            return null;
        }
        return keyProp;
    }

    static enum ArrayTypenameFlag {
        False,
        True;

    }
}

